/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.item.NewItemIdentifier;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.callback.RecoveryRetryCallback;
import org.springframework.batch.retry.policy.NeverRetryPolicy;
import org.springframework.batch.retry.policy.RecoveryCallbackRetryPolicy;
import org.springframework.batch.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class StatefulRetryOperationsInterceptor
implements MethodInterceptor {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private ItemKeyGenerator keyGenerator;
    private ItemRecoverer recoverer;
    private NewItemIdentifier newItemIdentifier;
    private final RetryTemplate retryTemplate = new RetryTemplate();

    public StatefulRetryOperationsInterceptor() {
        this.retryTemplate.setRetryPolicy(new RecoveryCallbackRetryPolicy(new NeverRetryPolicy()));
    }

    public void setRecoverer(ItemRecoverer recoverer) {
        this.recoverer = recoverer;
    }

    public void setKeyGenerator(ItemKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryTemplate.setRetryPolicy(new RecoveryCallbackRetryPolicy(retryPolicy));
    }

    public void setNewItemIdentifier(NewItemIdentifier newItemIdentifier) {
        this.newItemIdentifier = newItemIdentifier;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.logger.debug((Object)("Executing proxied method in stateful retry: " + invocation.getStaticPart() + "(" + ObjectUtils.getIdentityHexString((Object)invocation) + ")"));
        Object[] args = invocation.getArguments();
        Assert.state((args.length > 0 ? 1 : 0) != 0, (String)("Stateful retry applied to method that takes no arguments: " + invocation.getStaticPart()));
        Object arg = args;
        if (args.length == 1) {
            arg = args[0];
        }
        Object[] item = arg;
        RecoveryRetryCallback callback = new RecoveryRetryCallback(item, new MethodInvocationRetryCallback(invocation), this.keyGenerator != null ? this.keyGenerator.getKey(item) : item);
        callback.setRecoveryCallback(new ItemRecovererCallback(item, this.recoverer));
        if (this.newItemIdentifier != null) {
            callback.setForceRefresh(this.newItemIdentifier.isNew(item));
        }
        Object result = this.retryTemplate.execute(callback);
        this.logger.debug((Object)("Exiting proxied method in stateful retry with result: (" + result + ")"));
        return result;
    }

    private static final class ItemRecovererCallback
    implements RecoveryCallback {
        private final Object item;
        private final ItemRecoverer recoverer;

        private ItemRecovererCallback(Object item, ItemRecoverer recoverer) {
            this.item = item;
            this.recoverer = recoverer;
        }

        public Object recover(RetryContext context) {
            if (this.recoverer != null) {
                return this.recoverer.recover(this.item, context.getLastThrowable());
            }
            throw new ExhaustedRetryException("Retry was exhausted but there was no recovery path.");
        }
    }

    private static final class MethodInvocationRetryCallback
    implements RetryCallback {
        private final MethodInvocation invocation;

        private MethodInvocationRetryCallback(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        public Object doWithRetry(RetryContext context) throws Throwable {
            return this.invocation.proceed();
        }
    }
}

