/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.separator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.file.separator.DefaultRecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.LineReader;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ResourceLineReader
implements LineReader,
ItemReader {
    private static final Collection DEFAULT_COMMENTS = Collections.singleton("#");
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int READ_AHEAD_LIMIT = 100000;
    private final Resource resource;
    private final String encoding;
    private Collection comments = DEFAULT_COMMENTS;
    private State state = null;
    private RecordSeparatorPolicy recordSeparatorPolicy = new DefaultRecordSeparatorPolicy();

    public ResourceLineReader(Resource resource) throws IOException {
        this(resource, DEFAULT_ENCODING);
    }

    public ResourceLineReader(Resource resource, String encoding) {
        Assert.notNull((Object)resource, (String)"'resource' cannot be null.");
        Assert.notNull((Object)encoding, (String)"'encoding' cannot be null.");
        this.resource = resource;
        this.encoding = encoding;
    }

    public void setRecordSeparatorPolicy(RecordSeparatorPolicy recordSeparatorPolicy) {
        this.recordSeparatorPolicy = recordSeparatorPolicy;
    }

    public void setComments(String[] comments) {
        this.comments = new HashSet<String>(Arrays.asList(comments));
    }

    public synchronized Object read() {
        String line;
        RecordSeparatorPolicy recordSeparatorPolicy = this.recordSeparatorPolicy;
        String record = line = this.readLine();
        if (line != null) {
            while (line != null && !recordSeparatorPolicy.isEndOfRecord(record)) {
                line = this.readLine();
                record = recordSeparatorPolicy.preProcess(record) + line;
            }
        }
        return recordSeparatorPolicy.postProcess(record);
    }

    private String readLine() {
        return this.getState().readLine();
    }

    private State getState() {
        if (this.state == null) {
            this.open();
        }
        return this.state;
    }

    public synchronized void open() {
        this.state = new State();
        this.state.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.state == null) {
            return;
        }
        try {
            this.state.close();
        }
        finally {
            this.state = null;
        }
    }

    public int getPosition() {
        return this.getState().getCurrentLineCount();
    }

    public synchronized void mark() throws MarkFailedException {
        this.getState().mark();
    }

    public synchronized void reset() throws ResetFailedException {
        this.getState().reset();
    }

    private boolean isComment(String line) {
        Iterator iter = this.comments.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private class State {
        private BufferedReader reader;
        private int currentLineCount = 0;
        private int markedLineCount = -1;

        private State() {
        }

        public String readLine() {
            String line = null;
            try {
                line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                ++this.currentLineCount;
                while (ResourceLineReader.this.isComment(line)) {
                    line = this.reader.readLine();
                    if (line == null) {
                        return null;
                    }
                    ++this.currentLineCount;
                }
            }
            catch (IOException e) {
                throw new UnexpectedInputException("Unable to read from resource '" + ResourceLineReader.this.resource + "' at line " + this.currentLineCount, e);
            }
            return line;
        }

        public void open() {
            try {
                this.reader = new BufferedReader(new InputStreamReader(ResourceLineReader.this.resource.getInputStream(), ResourceLineReader.this.encoding));
                this.mark();
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not open resource", e);
            }
        }

        public void close() {
            if (this.reader == null) {
                return;
            }
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not close reader", e);
            }
            finally {
                this.currentLineCount = 0;
                this.markedLineCount = -1;
            }
        }

        public int getCurrentLineCount() {
            return this.currentLineCount;
        }

        public void mark() throws MarkFailedException {
            try {
                this.reader.mark(100000);
                this.markedLineCount = this.currentLineCount;
            }
            catch (IOException e) {
                throw new MarkFailedException("Could not mark reader", e);
            }
        }

        public void reset() throws ResetFailedException {
            if (this.markedLineCount < 0) {
                return;
            }
            try {
                this.reader.reset();
                this.currentLineCount = this.markedLineCount;
            }
            catch (IOException e) {
                throw new ResetFailedException("Could not reset reader", e);
            }
        }
    }
}

