/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractBufferedItemReaderItemStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdbcCursorItemReader
extends AbstractBufferedItemReaderItemStream
implements InitializingBean {
    private static Log log = LogFactory.getLog((Class)JdbcCursorItemReader.class);
    public static final int VALUE_NOT_SET = -1;
    private Connection con;
    private PreparedStatement preparedStatement;
    private PreparedStatementSetter preparedStatementSetter;
    protected ResultSet rs;
    private DataSource dataSource;
    private String sql;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean ignoreWarnings = true;
    private boolean verifyCursorPosition = true;
    private SQLExceptionTranslator exceptionTranslator;
    private RowMapper mapper;
    private boolean initialized = false;
    private boolean driverSupportsAbsolute = false;

    public JdbcCursorItemReader() {
        this.setName(ClassUtils.getShortName((Class)JdbcCursorItemReader.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSOurce must be provided");
        Assert.notNull((Object)this.sql, (String)"The SQL query must be provided");
        Assert.notNull((Object)this.mapper, (String)"RowMapper must be provided");
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private void executeQuery() {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must not be null.");
        try {
            this.con = this.dataSource.getConnection();
            this.preparedStatement = this.con.prepareStatement(this.sql, 1003, 1007, 1);
            this.applyStatementSettings(this.preparedStatement);
            if (this.preparedStatementSetter != null) {
                this.preparedStatementSetter.setValues(this.preparedStatement);
            }
            this.rs = this.preparedStatement.executeQuery();
            this.handleWarnings(this.preparedStatement.getWarnings());
        }
        catch (SQLException se) {
            this.close(null);
            throw this.getExceptionTranslator().translate("Executing query", this.sql, se);
        }
    }

    private void applyStatementSettings(PreparedStatement stmt) throws SQLException {
        if (this.fetchSize != -1) {
            stmt.setFetchSize(this.fetchSize);
            stmt.setFetchDirection(1000);
        }
        if (this.maxRows != -1) {
            stmt.setMaxRows(this.maxRows);
        }
        if (this.queryTimeout != -1) {
            stmt.setQueryTimeout(this.queryTimeout);
        }
    }

    protected SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = this.dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(this.dataSource) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    private void handleWarnings(SQLWarning warnings) throws SQLWarningException {
        if (this.ignoreWarnings) {
            for (SQLWarning warningToLog = warnings; warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                log.debug((Object)("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]"));
            }
        } else if (warnings != null) {
            throw new SQLWarningException("Warning not ignored", warnings);
        }
    }

    private void moveCursorToRow(int row) {
        try {
            int count = 0;
            while (this.rs.next() && ++count != row) {
            }
        }
        catch (SQLException se) {
            throw this.getExceptionTranslator().translate("Attempted to move ResultSet to last committed row", this.sql, se);
        }
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public void setVerifyCursorPosition(boolean verifyCursorPosition) {
        this.verifyCursorPosition = verifyCursorPosition;
    }

    public void setMapper(RowMapper mapper) {
        this.mapper = mapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setDriverSupportsAbsolute(boolean driverSupportsAbsolute) {
        this.driverSupportsAbsolute = driverSupportsAbsolute;
    }

    private void verifyCursorPosition(long expectedCurrentRow) throws SQLException {
        if (this.verifyCursorPosition && expectedCurrentRow != (long)this.rs.getRow()) {
            throw new InvalidDataAccessResourceUsageException("Unexpected cursor position change.");
        }
    }

    protected void doClose() throws Exception {
        this.initialized = false;
        JdbcUtils.closeResultSet((ResultSet)this.rs);
        JdbcUtils.closeStatement((Statement)this.preparedStatement);
        JdbcUtils.closeConnection((Connection)this.con);
        this.rs = null;
    }

    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Stream is already initialized.  Close before re-opening.");
        Assert.isNull((Object)this.rs, (String)"ResultSet still open!  Close before re-opening.");
        this.executeQuery();
        this.initialized = true;
    }

    protected Object doRead() throws Exception {
        try {
            if (!this.rs.next()) {
                return null;
            }
            int currentRow = this.getCurrentItemCount();
            Object item = this.mapper.mapRow(this.rs, currentRow);
            this.verifyCursorPosition(currentRow);
            return item;
        }
        catch (SQLException se) {
            throw this.getExceptionTranslator().translate("Attempt to process next row failed", this.sql, se);
        }
    }

    protected void jumpToItem(int itemIndex) throws Exception {
        if (this.driverSupportsAbsolute) {
            try {
                this.rs.absolute(itemIndex);
            }
            catch (SQLException e) {
                log.warn((Object)"The JDBC driver does not appear to support ResultSet.absolute(). Consider reverting to the default behavior setting the driverSupportsAbsolute to false", (Throwable)e);
                this.moveCursorToRow(itemIndex);
            }
        } else {
            this.moveCursorToRow(itemIndex);
        }
    }
}

