/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterUnpackerFilter
extends OncePerRequestFilter {
    private String prefix = "unpack_";
    private String delimiter = "|";
    private boolean putEmptyParamsInPath = false;

    public void setPutEmptyParamsInPath(boolean putEmptyParamsInPath) {
        this.putEmptyParamsInPath = putEmptyParamsInPath;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HashMap<String, String[]> unpacked = new HashMap<String, String[]>();
        ArrayList<? extends String> pathKeys = new ArrayList<String>();
        for (Object key : request.getParameterMap().keySet()) {
            String paramName = (String)key;
            if (!paramName.startsWith(this.prefix)) continue;
            String embedded = paramName.substring(this.prefix.length());
            unpacked.putAll(this.unpack(embedded, this.delimiter));
            pathKeys.addAll(this.extractPathKeys(embedded, this.delimiter));
        }
        if (unpacked.size() > 0) {
            filterChain.doFilter((ServletRequest)new EnhancedRequestWrapper(unpacked, request, this.putEmptyParamsInPath ? pathKeys : Collections.emptyList()), (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected Collection<? extends String> extractPathKeys(String paramName, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        String[] values = StringUtils.delimitedListToStringArray((String)paramName, (String)delimiter);
        for (int i = 0; i < (values.length + 1) / 2; ++i) {
            String next;
            int j = 2 * i + 1;
            String key = values[j - 1];
            String string = next = j < values.length ? values[j].trim() : "";
            if (next == null || next.length() != 0) continue;
            result.add(key);
        }
        return result;
    }

    protected Map<String, String[]> unpack(String paramName, String delimiter) {
        HashMap<String, String[]> unpacked = new HashMap<String, String[]>();
        String[] values = StringUtils.delimitedListToStringArray((String)paramName, (String)delimiter);
        for (int i = 0; i < (values.length + 1) / 2; ++i) {
            String next;
            int j = 2 * i + 1;
            String key = values[j - 1];
            String[] saved = (String[])unpacked.get(key);
            String string = next = j < values.length ? values[j] : "";
            if (saved == null) {
                saved = new String[]{next};
            } else {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(saved));
                list.add(next);
                saved = list.toArray(new String[list.size()]);
            }
            unpacked.put(key, saved);
        }
        return unpacked;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnhancedRequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, String[]> params = new HashMap<String, String[]>();
        private final List<String> pathParams;

        public EnhancedRequestWrapper(Map<String, String[]> params, HttpServletRequest request, List<String> pathParams) {
            super(request);
            this.pathParams = pathParams;
            this.params.putAll(params);
        }

        public String getContextPath() {
            String base = super.getContextPath();
            if (this.pathParams != null && this.pathParams.isEmpty()) {
                return base;
            }
            StringBuffer buffer = new StringBuffer(base);
            for (String key : this.pathParams) {
                buffer.append("/" + key);
            }
            return buffer.toString();
        }

        public Enumeration<String> getParameterNames() {
            HashSet<String> paramNames = new HashSet<String>();
            Enumeration paramEnum = super.getParameterNames();
            while (paramEnum.hasMoreElements()) {
                paramNames.add((String)paramEnum.nextElement());
            }
            paramNames.addAll(this.params.keySet());
            return Collections.enumeration(paramNames);
        }

        public String getParameter(String name) {
            String[] value = this.params.get(name);
            if (value != null) {
                return value.length > 0 ? value[0] : null;
            }
            return super.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            String[] value = this.params.get(name);
            if (value != null) {
                return value;
            }
            return super.getParameterValues(name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
            paramMap.putAll(super.getParameterMap());
            paramMap.putAll(this.params);
            return paramMap;
        }
    }
}

