/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.Transformer;
import org.springframework.util.Assert;

@MessageEndpoint
public class LastJobParametersJobLaunchRequestEnhancer
implements InitializingBean {
    private JobService jobService;

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobService, (String)"A JobService must be provided");
    }

    @Transformer
    public JobLaunchRequest adapt(JobLaunchRequest request) throws NoSuchJobException {
        Map jobParameters = request.getJobParameters().getParameters();
        Map oldParameters = this.jobService.getLastJobParameters(request.getJob().getName()).getParameters();
        HashMap map = new HashMap();
        for (String key : oldParameters.keySet()) {
            map.put(key, oldParameters.get(key));
        }
        for (String key : jobParameters.keySet()) {
            map.put(key, jobParameters.get(key));
        }
        return new JobLaunchRequest(request.getJob(), new JobParameters(map));
    }
}

