/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.memory;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.analytics.metrics.FieldValueCounter;
import org.springframework.analytics.metrics.FieldValueCounterRepository;
import org.springframework.util.Assert;

public class InMemoryFieldValueCounterRepository
implements FieldValueCounterRepository {
    private final ConcurrentMap<String, FieldValueCounter> map = new ConcurrentHashMap<String, FieldValueCounter>();

    @Override
    public void increment(String name, String fieldName, double score) {
        this.modifyFieldValue(name, fieldName, score);
    }

    @Override
    public void decrement(String name, String fieldName, double score) {
        this.modifyFieldValue(name, fieldName, -score);
    }

    @Override
    public void reset(String name) {
        this.map.remove(name);
    }

    private void modifyFieldValue(String name, String fieldName, double delta) {
        FieldValueCounter counter = this.getOrCreate(name);
        Map<String, Double> data = counter.getFieldValueCounts();
        double count = data.containsKey(fieldName) ? data.get(fieldName) : 0.0;
        data.put(fieldName, count + delta);
        this.save(counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldValueCounter getOrCreate(String name) {
        FieldValueCounter result = this.findOne(name);
        if (result == null) {
            ConcurrentMap<String, FieldValueCounter> concurrentMap = this.map;
            synchronized (concurrentMap) {
                result = this.create(name);
            }
            result = this.save(result);
        }
        return result;
    }

    private FieldValueCounter save(FieldValueCounter fieldValueCounter) {
        this.map.put(fieldValueCounter.getName(), fieldValueCounter);
        return fieldValueCounter;
    }

    @Override
    public FieldValueCounter findOne(String name) {
        Assert.notNull((Object)name, (String)"The name of the metric must not be null");
        return (FieldValueCounter)this.map.get(name);
    }

    @Override
    public Collection<String> list() {
        return this.map.keySet();
    }

    private FieldValueCounter create(String name) {
        return new FieldValueCounter(name);
    }
}

