/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.rabbit.stream.config.SuperStream;
import org.springframework.util.StringUtils;

public class SuperStreamBuilder {
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private @Nullable String name;
    private int partitions = -1;
    private @Nullable BiFunction<String, Integer, List<String>> routingKeyStrategy;

    public static SuperStreamBuilder superStream(String name) {
        SuperStreamBuilder builder = new SuperStreamBuilder();
        builder.name(name);
        return builder;
    }

    public static SuperStreamBuilder superStream(String name, int partitions) {
        return SuperStreamBuilder.superStream(name).partitions(partitions);
    }

    public SuperStreamBuilder maxAge(String maxAge) {
        return this.withArgument("x-max-age", maxAge);
    }

    public SuperStreamBuilder maxLength(long bytes) {
        return this.withArgument("max-length-bytes", bytes);
    }

    public SuperStreamBuilder maxSegmentSize(long bytes) {
        return this.withArgument("x-stream-max-segment-size-bytes", bytes);
    }

    public SuperStreamBuilder initialClusterSize(int count) {
        return this.withArgument("x-initial-cluster-size", count);
    }

    public SuperStreamBuilder withArgument(String key, Object value) {
        if ("x-queue-type".equals(key) && !"stream".equals(value)) {
            throw new IllegalArgumentException("Changing x-queue-type argument is not permitted");
        }
        this.arguments.put(key, value);
        return this;
    }

    public SuperStreamBuilder name(String name) {
        this.name = name;
        return this;
    }

    public SuperStreamBuilder partitions(int partitions) {
        this.partitions = partitions;
        return this;
    }

    public SuperStreamBuilder routingKeyStrategy(BiFunction<String, Integer, List<String>> routingKeyStrategy) {
        this.routingKeyStrategy = routingKeyStrategy;
        return this;
    }

    public SuperStream build() {
        if (!StringUtils.hasText((String)this.name)) {
            throw new IllegalArgumentException("Stream name can't be empty");
        }
        if (this.partitions <= 0) {
            throw new IllegalArgumentException(String.format("Partitions number should be great then zero. Current value; %d", this.partitions));
        }
        if (this.routingKeyStrategy == null) {
            return new SuperStream(this.name, this.partitions, this.arguments);
        }
        return new SuperStream(this.name, this.partitions, this.routingKeyStrategy, this.arguments);
    }
}

