/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.micrometer;

import com.rabbitmq.stream.Message;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.transport.ReceiverContext;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservation;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservationConvention;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageReceiverContext;

public class RabbitStreamMessageReceiverContext
extends ReceiverContext<Message> {
    private final String listenerId;
    private final Message message;
    private final String stream;

    public RabbitStreamMessageReceiverContext(Message message, String listenerId, String stream) {
        super((carrier, key) -> {
            Map props = carrier.getApplicationProperties();
            if (props != null) {
                Object value = carrier.getApplicationProperties().get(key);
                if (value instanceof String) {
                    String string = (String)value;
                    return string;
                }
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    return new String(bytes, StandardCharsets.UTF_8);
                }
            }
            return null;
        });
        this.setCarrier(message);
        this.message = message;
        this.listenerId = listenerId;
        this.stream = stream;
        this.setRemoteServiceName("RabbitMQ Stream");
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getSource() {
        return this.stream;
    }

    public static class DefaultRabbitListenerObservationConvention
    implements RabbitListenerObservationConvention {
        public static final DefaultRabbitListenerObservationConvention INSTANCE = new DefaultRabbitListenerObservationConvention();

        public KeyValues getLowCardinalityKeyValues(RabbitMessageReceiverContext context) {
            return KeyValues.of((String)RabbitListenerObservation.ListenerLowCardinalityTags.LISTENER_ID.asString(), (String)context.getListenerId());
        }

        public String getContextualName(RabbitMessageReceiverContext context) {
            return context.getSource() + " receive";
        }
    }
}

