/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.http.client.Client;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.amqp.rabbit.junit.BrokerTestUtils;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public final class BrokerRunning
extends TestWatcher {
    private static final int SIXTEEN = 16;
    public static final String BROKER_ADMIN_URI = "RABBITMQ_TEST_ADMIN_URI";
    public static final String BROKER_HOSTNAME = "RABBITMQ_TEST_HOSTNAME";
    public static final String BROKER_PORT = "RABBITMQ_TEST_PORT";
    public static final String BROKER_USER = "RABBITMQ_TEST_USER";
    public static final String BROKER_PW = "RABBITMQ_TEST_PASSWORD";
    public static final String BROKER_ADMIN_USER = "RABBITMQ_TEST_ADMIN_USER";
    public static final String BROKER_ADMIN_PW = "RABBITMQ_TEST_ADMIN_PASSWORD";
    public static final String BROKER_REQUIRED = "RABBITMQ_SERVER_REQUIRED";
    private static final String DEFAULT_QUEUE_NAME = BrokerRunning.class.getName();
    private static final String GUEST = "guest";
    private static final Log logger = LogFactory.getLog(BrokerRunning.class);
    private static final Map<Integer, Boolean> brokerOnline = new HashMap<Integer, Boolean>();
    private static final Map<Integer, Boolean> brokerOffline = new HashMap<Integer, Boolean>();
    private static final Map<String, String> environmentOverrides = new HashMap<String, String>();
    private final boolean assumeOnline;
    private final boolean purge;
    private final boolean management;
    private final String[] queues;
    private final int defaultPort = this.fromEnvironment("RABBITMQ_TEST_PORT", null) == null ? BrokerTestUtils.getPort() : Integer.valueOf(this.fromEnvironment("RABBITMQ_TEST_PORT", null));
    private int port;
    private String hostName = this.fromEnvironment("RABBITMQ_TEST_HOSTNAME", "localhost");
    private String adminUri = this.fromEnvironment("RABBITMQ_TEST_ADMIN_URI", null);
    private ConnectionFactory connectionFactory;
    private String user = this.fromEnvironment("RABBITMQ_TEST_USER", "guest");
    private String password = this.fromEnvironment("RABBITMQ_TEST_PASSWORD", "guest");
    private String adminUser = this.fromEnvironment("RABBITMQ_TEST_ADMIN_USER", "guest");
    private String adminPassword = this.fromEnvironment("RABBITMQ_TEST_ADMIN_PASSWORD", "guest");

    private String fromEnvironment(String key, String defaultValue) {
        String environmentValue = environmentOverrides.get(key);
        if (!StringUtils.hasText((String)environmentValue)) {
            environmentValue = System.getenv(key);
        }
        if (StringUtils.hasText((String)environmentValue)) {
            return environmentValue;
        }
        return defaultValue;
    }

    public static void setEnvironmentVariableOverrides(Map<String, String> environmentVariables) {
        environmentOverrides.putAll(environmentVariables);
    }

    public static void clearEnvironmentVariableOverrides() {
        environmentOverrides.clear();
    }

    public static BrokerRunning isRunningWithEmptyQueues(String ... names) {
        return new BrokerRunning(true, true, names);
    }

    public static BrokerRunning isRunning() {
        return new BrokerRunning(true);
    }

    public static BrokerRunning isNotRunning() {
        return new BrokerRunning(false);
    }

    public static BrokerRunning isBrokerAndManagementRunning() {
        return new BrokerRunning(true, false, true);
    }

    public static BrokerRunning isBrokerAndManagementRunningWithEmptyQueues(String ... queues) {
        return new BrokerRunning(true, false, true, queues);
    }

    private BrokerRunning(boolean assumeOnline, boolean purge, String ... queues) {
        this(assumeOnline, purge, false, queues);
    }

    private BrokerRunning(boolean assumeOnline, boolean purge, boolean management, String ... queues) {
        this.assumeOnline = assumeOnline;
        this.queues = queues;
        this.purge = purge;
        this.management = management;
        this.setPort(this.defaultPort);
    }

    private BrokerRunning(boolean assumeOnline, String ... queues) {
        this(assumeOnline, false, queues);
    }

    private BrokerRunning(boolean assumeOnline) {
        this(assumeOnline, DEFAULT_QUEUE_NAME);
    }

    private BrokerRunning(boolean assumeOnline, boolean purge, boolean management) {
        this(assumeOnline, purge, management, DEFAULT_QUEUE_NAME);
    }

    public void setPort(int port) {
        this.port = port;
        if (!brokerOffline.containsKey(port)) {
            brokerOffline.put(port, true);
        }
        if (!brokerOnline.containsKey(port)) {
            brokerOnline.put(port, true);
        }
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAdminUri(String adminUri) {
        this.adminUri = adminUri;
    }

    public void setAdminUser(String user) {
        this.adminUser = user;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement apply(Statement base, Description description) {
        if (this.assumeOnline) {
            Assume.assumeTrue((boolean)brokerOnline.get(this.port));
        } else {
            Assume.assumeTrue((boolean)brokerOffline.get(this.port));
        }
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            channel = this.createQueues(connection);
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            try {
                logger.warn((Object)("Not executing tests because basic connectivity test failed: " + e.getMessage()));
                brokerOnline.put(this.port, false);
                if (this.assumeOnline) {
                    if (BrokerRunning.fatal()) {
                        Assert.fail((String)"RabbitMQ Broker is required, but not available");
                    } else {
                        Assume.assumeNoException((Throwable)e);
                    }
                }
                this.closeResources(connection, channel);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, channel);
                throw throwable;
            }
        }
        return super.apply(base, description);
    }

    public void isUp() throws IOException, TimeoutException, URISyntaxException {
        Connection connection = this.getConnectionFactory().newConnection();
        Channel channel = null;
        try {
            channel = this.createQueues(connection);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    private Connection getConnection(ConnectionFactory connectionFactory) throws IOException, TimeoutException {
        Connection connection = connectionFactory.newConnection();
        connection.setId(this.generateId());
        return connection;
    }

    private Channel createQueues(Connection connection) throws IOException, MalformedURLException, URISyntaxException {
        Client client;
        Channel channel = connection.createChannel();
        for (String queueName : this.queues) {
            if (this.purge) {
                logger.debug((Object)("Deleting queue: " + queueName));
                channel.queueDelete(queueName);
            }
            if (this.isDefaultQueue(queueName)) {
                channel.queueDelete(queueName);
                continue;
            }
            channel.queueDeclare(queueName, true, false, false, null);
        }
        brokerOffline.put(this.port, false);
        if (!this.assumeOnline) {
            Assume.assumeTrue((boolean)brokerOffline.get(this.port));
        }
        if (this.management && !(client = new Client(this.getAdminUri(), this.adminUser, this.adminPassword)).alivenessTest("/")) {
            throw new BrokerNotAliveException("Aliveness test failed for localhost:15672 guest/quest; management not available");
        }
        return channel;
    }

    public static boolean fatal() {
        String serversRequired = System.getenv(BROKER_REQUIRED);
        if (Boolean.parseBoolean(serversRequired)) {
            logger.error((Object)"RABBITMQ IS REQUIRED BUT NOT AVAILABLE");
            return true;
        }
        return false;
    }

    public String generateId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return "SpringBrokerRunning." + Base64Utils.encodeToUrlSafeString((byte[])bb.array()).replaceAll("=", "");
    }

    private boolean isDefaultQueue(String queue) {
        return DEFAULT_QUEUE_NAME.equals(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestQueues(String ... additionalQueues) {
        List<String> queuesToRemove = Arrays.asList(this.queues);
        if (additionalQueues != null) {
            queuesToRemove = new ArrayList<String>(queuesToRemove);
            queuesToRemove.addAll(Arrays.asList(additionalQueues));
        }
        logger.debug((Object)("deleting test queues: " + queuesToRemove));
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".queueDelete");
            channel = connection.createChannel();
            for (String queue : queuesToRemove) {
                channel.queueDelete(queue);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQueues(String ... queues) {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".queueDelete");
            channel = connection.createChannel();
            for (String queue : queues) {
                channel.queueDelete(queue);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExchanges(String ... exchanges) {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getConnection(this.getConnectionFactory());
            connection.setId(this.generateId() + ".exchangeDelete");
            channel = connection.createChannel();
            for (String exchange : exchanges) {
                channel.exchangeDelete(exchange);
            }
            this.closeResources(connection, channel);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete queues", (Throwable)e);
        }
        finally {
            this.closeResources(connection, channel);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ConnectionFactory();
            if (StringUtils.hasText((String)this.hostName)) {
                this.connectionFactory.setHost(this.hostName);
            } else {
                this.connectionFactory.setHost("localhost");
            }
            this.connectionFactory.setPort(this.port);
            this.connectionFactory.setUsername(this.user);
            this.connectionFactory.setPassword(this.password);
            this.connectionFactory.setAutomaticRecoveryEnabled(false);
        }
        return this.connectionFactory;
    }

    public String getAdminUri() {
        if (!StringUtils.hasText((String)this.adminUri)) {
            this.adminUri = !StringUtils.hasText((String)this.hostName) ? "http://localhost:15672/api/" : "http://" + this.hostName + ":15672/api/";
        }
        return this.adminUri;
    }

    private void closeResources(Connection connection, Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException | TimeoutException exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class BrokerNotAliveException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        BrokerNotAliveException(String message) {
            super(message);
        }
    }
}

