/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.exec;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.exec.ExecuteStreamHandler;
import org.springframework.util.exec.ExecuteWatchdog;
import org.springframework.util.exec.Os;
import org.springframework.util.exec.PumpStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Execute {
    private static Log log = LogFactory.getLog(Execute.class);
    public static final int INVALID = Integer.MAX_VALUE;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private boolean newEnvironment = false;
    private Process process;
    private static Vector<String> procEnvironment = null;

    public static synchronized Vector<String> getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Execute exe = new Execute(new PumpStreamHandler(out));
            exe.setCommandline(Execute.getProcEnvCommand());
            exe.setNewenvironment(true);
            int retval = exe.execute();
            if (retval != 0) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new StringReader(out.toString()));
            String var = null;
            String lineSep = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    procEnvironment.addElement(var);
                }
                var = line;
            }
            procEnvironment.addElement(var);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("windows")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("unix")) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        if (Os.isFamily("netware")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler streamHandler) {
        this(streamHandler, null);
    }

    public Execute(ExecuteStreamHandler streamHandler, ExecuteWatchdog watchdog) {
        this.streamHandler = streamHandler;
        this.watchdog = watchdog;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public String getCommandLineString() {
        return this.array2string(this.getCommandline());
    }

    public void setCommandline(String[] commandline) {
        this.cmdl = commandline;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setWorkingDirectory(File wd) {
        this.workingDirectory = wd;
    }

    public int execute() throws Exception {
        Exception ex;
        this.process = Runtime.getRuntime().exec(this.getCommandline(), this.getEnvironment(), this.workingDirectory);
        try {
            this.streamHandler.setProcessInputStream(this.process.getOutputStream());
            this.streamHandler.setProcessOutputStream(this.process.getInputStream());
            this.streamHandler.setProcessErrorStream(this.process.getErrorStream());
        }
        catch (IOException e) {
            this.process.destroy();
            throw e;
        }
        this.streamHandler.start();
        if (this.watchdog != null) {
            this.watchdog.start(this.process, Thread.currentThread());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Waiting process ");
        }
        this.waitFor(this.process);
        this.process = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"End waiting, stop threads ");
        }
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Watchdog stopped ");
        }
        this.streamHandler.stop();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stream handler stopped ");
        }
        if (this.watchdog != null && (ex = this.watchdog.getException()) != null) {
            throw ex;
        }
        int exit = this.getExitValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Done exit=" + exit + " " + this.getCommandLineString()));
        }
        return exit;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private String array2string(String[] sa) {
        if (sa == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sa.length; ++i) {
            sb.append(sa[i]).append(" ");
        }
        return sb.toString();
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException e) {
            log.info((Object)"waitFor() interrupted ");
            Thread.currentThread().interrupt();
        }
    }

    protected void setExitValue(int value) {
        this.exitValue = value;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private String[] patchEnvironment() {
        Vector osEnv = (Vector)Execute.getProcEnvironment().clone();
        for (int i = 0; i < this.env.length; ++i) {
            int pos = this.env[i].indexOf(61);
            String key = this.env[i].substring(0, pos + 1);
            int size = osEnv.size();
            for (int j = 0; j < size; ++j) {
                if (!((String)osEnv.elementAt(j)).startsWith(key)) continue;
                osEnv.removeElementAt(j);
                break;
            }
            osEnv.addElement(this.env[i]);
        }
        Object[] result = new String[osEnv.size()];
        osEnv.copyInto(result);
        return result;
    }

    public static int execute(Vector<String> envVars, String cmd, File baseDir) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(cmd, " ");
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return Execute.execute(envVars, v, baseDir);
    }

    public static int execute(Vector<String> envVars, Vector<String> cmd, File baseDir) {
        return Execute.execute(envVars, cmd, baseDir, 10000);
    }

    public static int execute(Vector<String> envVars, Vector<String> cmd, File baseDir, int timeToWait) {
        try {
            ExecuteWatchdog watchdog = new ExecuteWatchdog(timeToWait);
            watchdog.setDontkill(true);
            PumpStreamHandler out = new PumpStreamHandler();
            Execute exec = new Execute(out, watchdog);
            String[] cmdA = new String[cmd.size()];
            cmd.toArray(cmdA);
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < cmdA.length; ++i) {
                    sb.append(cmdA[i] + " ");
                }
                log.debug((Object)("Exec: " + sb.toString()));
            }
            exec.setCommandline(cmdA);
            if (envVars != null) {
                String[] env = new String[envVars.size()];
                envVars.toArray(env);
                exec.setEnvironment(env);
            }
            exec.setNewenvironment(false);
            if (baseDir != null) {
                exec.setWorkingDirectory(baseDir);
            }
            exec.execute();
            int status = exec.getExitValue();
            log.debug((Object)("Exit value " + status));
            return status;
        }
        catch (Exception ex) {
            System.err.println("An error has occurred in Execute.");
            return -1;
        }
    }
}

