/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.erlang.connection;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.erlang.OtpIOException;
import org.springframework.erlang.connection.Connection;
import org.springframework.erlang.connection.ConnectionFactory;
import org.springframework.erlang.connection.DefaultConnection;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleConnectionFactory
implements ConnectionFactory,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean uniqueSelfNodeName = true;
    private final String selfNodeName;
    private final String peerNodeName;
    private final String cookie;
    private OtpSelf otpSelf;
    private OtpPeer otpPeer;

    public SimpleConnectionFactory(String selfNodeName, String peerNodeName, String cookie) {
        this.selfNodeName = selfNodeName;
        this.peerNodeName = peerNodeName;
        this.cookie = cookie;
    }

    public SimpleConnectionFactory(String selfNodeName, String peerNodeName) {
        this(selfNodeName, peerNodeName, null);
    }

    public Connection createConnection() throws UnknownHostException, OtpAuthException, IOException {
        try {
            return new DefaultConnection(this.otpSelf.connect(this.otpPeer));
        }
        catch (IOException ex) {
            throw new OtpIOException("failed to connect from '" + this.selfNodeName + "' to peer node '" + this.peerNodeName + "'", ex);
        }
    }

    public boolean isUniqueSelfNodeName() {
        return this.uniqueSelfNodeName;
    }

    public void setUniqueSelfNodeName(boolean uniqueSelfNodeName) {
        this.uniqueSelfNodeName = uniqueSelfNodeName;
    }

    public void afterPropertiesSet() {
        Assert.isTrue((this.selfNodeName != null && this.peerNodeName != null ? 1 : 0) != 0, (String)"'selfNodeName' and 'peerNodeName' are required");
        String selfNodeNameToUse = this.selfNodeName;
        if (this.isUniqueSelfNodeName()) {
            selfNodeNameToUse = this.selfNodeName + "-" + UUID.randomUUID().toString();
            this.logger.debug((Object)("Creating OtpSelf with node name = [" + selfNodeNameToUse + "]"));
        }
        try {
            this.otpSelf = StringUtils.hasText((String)this.cookie) ? new OtpSelf(selfNodeNameToUse.trim(), this.cookie) : new OtpSelf(selfNodeNameToUse.trim());
        }
        catch (IOException e) {
            throw new OtpIOException(e);
        }
        this.otpPeer = new OtpPeer(this.peerNodeName.trim());
    }
}

