/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatModel;
import org.springframework.ai.vertexai.gemini.common.VertexAiGeminiSafetySetting;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiGeminiChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonProperty(value="topK")
    private Integer topK;
    @JsonProperty(value="candidateCount")
    private Integer candidateCount;
    @JsonProperty(value="maxOutputTokens")
    private Integer maxOutputTokens;
    @JsonProperty(value="modelName")
    private String model;
    @JsonProperty(value="responseMimeType")
    private String responseMimeType;
    @JsonIgnore
    private List<FunctionCallback> toolCallbacks = new ArrayList<FunctionCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Boolean googleSearchRetrieval = false;
    @JsonIgnore
    private List<VertexAiGeminiSafetySetting> safetySettings = new ArrayList<VertexAiGeminiSafetySetting>();

    public static Builder builder() {
        return new Builder();
    }

    public static VertexAiGeminiChatOptions fromOptions(VertexAiGeminiChatOptions fromOptions) {
        VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();
        options.setStopSequences(fromOptions.getStopSequences());
        options.setTemperature(fromOptions.getTemperature());
        options.setTopP(fromOptions.getTopP());
        options.setTopK(fromOptions.getTopK());
        options.setCandidateCount(fromOptions.getCandidateCount());
        options.setMaxOutputTokens(fromOptions.getMaxOutputTokens());
        options.setModel(fromOptions.getModel());
        options.setToolCallbacks(fromOptions.getToolCallbacks());
        options.setResponseMimeType(fromOptions.getResponseMimeType());
        options.setToolNames(fromOptions.getToolNames());
        options.setResponseMimeType(fromOptions.getResponseMimeType());
        options.setGoogleSearchRetrieval(fromOptions.getGoogleSearchRetrieval());
        options.setSafetySettings(fromOptions.getSafetySettings());
        options.setInternalToolExecutionEnabled(fromOptions.isInternalToolExecutionEnabled());
        options.setToolContext(fromOptions.getToolContext());
        return options;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxOutputTokens();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxOutputTokens(maxTokens);
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String modelName) {
        this.model = modelName;
    }

    public String getResponseMimeType() {
        return this.responseMimeType;
    }

    public void setResponseMimeType(String mimeType) {
        this.responseMimeType = mimeType;
    }

    @JsonIgnore
    @Deprecated
    public List<FunctionCallback> getFunctionCallbacks() {
        return this.getToolCallbacks();
    }

    @JsonIgnore
    @Deprecated
    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.setToolCallbacks(functionCallbacks);
    }

    public List<FunctionCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    public void setToolCallbacks(List<FunctionCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    @Deprecated
    public Set<String> getFunctions() {
        return this.getToolNames();
    }

    @JsonIgnore
    @Deprecated
    public void setFunctions(Set<String> functions) {
        this.setToolNames(functions);
    }

    public Set<String> getToolNames() {
        return this.toolNames;
    }

    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    public Boolean isInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    public Boolean getGoogleSearchRetrieval() {
        return this.googleSearchRetrieval;
    }

    public void setGoogleSearchRetrieval(Boolean googleSearchRetrieval) {
        this.googleSearchRetrieval = googleSearchRetrieval;
    }

    public List<VertexAiGeminiSafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public void setSafetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
        Assert.notNull(safetySettings, (String)"safetySettings must not be null");
        this.safetySettings = safetySettings;
    }

    @Deprecated
    @JsonIgnore
    public Boolean getProxyToolCalls() {
        return this.internalToolExecutionEnabled != null ? Boolean.valueOf(this.internalToolExecutionEnabled == false) : null;
    }

    @Deprecated
    @JsonIgnore
    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.internalToolExecutionEnabled = proxyToolCalls != null ? Boolean.valueOf(proxyToolCalls == false) : null;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexAiGeminiChatOptions)) {
            return false;
        }
        VertexAiGeminiChatOptions that = (VertexAiGeminiChatOptions)o;
        return this.googleSearchRetrieval == that.googleSearchRetrieval && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.candidateCount, that.candidateCount) && Objects.equals(this.maxOutputTokens, that.maxOutputTokens) && Objects.equals(this.model, that.model) && Objects.equals(this.responseMimeType, that.responseMimeType) && Objects.equals(this.toolCallbacks, that.toolCallbacks) && Objects.equals(this.toolNames, that.toolNames) && Objects.equals(this.safetySettings, that.safetySettings) && Objects.equals(this.internalToolExecutionEnabled, that.internalToolExecutionEnabled) && Objects.equals(this.toolContext, that.toolContext);
    }

    public int hashCode() {
        return Objects.hash(this.stopSequences, this.temperature, this.topP, this.topK, this.candidateCount, this.maxOutputTokens, this.model, this.responseMimeType, this.toolCallbacks, this.toolNames, this.googleSearchRetrieval, this.safetySettings, this.internalToolExecutionEnabled, this.toolContext);
    }

    public String toString() {
        return "VertexAiGeminiChatOptions{stopSequences=" + String.valueOf(this.stopSequences) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", candidateCount=" + this.candidateCount + ", maxOutputTokens=" + this.maxOutputTokens + ", model='" + this.model + "', responseMimeType='" + this.responseMimeType + "', toolCallbacks=" + String.valueOf(this.toolCallbacks) + ", toolNames=" + String.valueOf(this.toolNames) + ", googleSearchRetrieval=" + this.googleSearchRetrieval + ", safetySettings=" + String.valueOf(this.safetySettings) + "}";
    }

    public VertexAiGeminiChatOptions copy() {
        return VertexAiGeminiChatOptions.fromOptions(this);
    }

    public static class Builder {
        private VertexAiGeminiChatOptions options = new VertexAiGeminiChatOptions();

        public Builder stopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder topP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder topK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder candidateCount(Integer candidateCount) {
            this.options.setCandidateCount(candidateCount);
            return this;
        }

        public Builder maxOutputTokens(Integer maxOutputTokens) {
            this.options.setMaxOutputTokens(maxOutputTokens);
            return this;
        }

        public Builder model(String modelName) {
            this.options.setModel(modelName);
            return this;
        }

        public Builder model(VertexAiGeminiChatModel.ChatModel model) {
            this.options.setModel(model.getValue());
            return this;
        }

        public Builder responseMimeType(String mimeType) {
            Assert.notNull((Object)mimeType, (String)"mimeType must not be null");
            this.options.setResponseMimeType(mimeType);
            return this;
        }

        @Deprecated
        public Builder functionCallbacks(List<FunctionCallback> functionCallbacks) {
            return this.toolCallbacks(functionCallbacks);
        }

        public Builder toolCallbacks(List<FunctionCallback> toolCallbacks) {
            this.options.toolCallbacks = toolCallbacks;
            return this;
        }

        public Builder toolCallbacks(FunctionCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        @Deprecated
        public Builder functions(Set<String> functionNames) {
            return this.toolNames(functionNames);
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"Function names must not be null");
            this.options.toolNames = toolNames;
            return this;
        }

        @Deprecated
        public Builder function(String functionName) {
            return this.toolName(functionName);
        }

        public Builder toolName(String toolName) {
            Assert.hasText((String)toolName, (String)"Function name must not be empty");
            this.options.toolNames.add(toolName);
            return this;
        }

        public Builder googleSearchRetrieval(boolean googleSearch) {
            this.options.googleSearchRetrieval = googleSearch;
            return this;
        }

        public Builder safetySettings(List<VertexAiGeminiSafetySetting> safetySettings) {
            Assert.notNull(safetySettings, (String)"safetySettings must not be null");
            this.options.safetySettings = safetySettings;
            return this;
        }

        @Deprecated
        public Builder proxyToolCalls(boolean proxyToolCalls) {
            return this.internalToolExecutionEnabled(!proxyToolCalls);
        }

        public Builder internalToolExecutionEnabled(boolean internalToolExecutionEnabled) {
            this.options.internalToolExecutionEnabled = internalToolExecutionEnabled;
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public VertexAiGeminiChatOptions build() {
            return this.options;
        }
    }

    public static enum TransportType {
        GRPC,
        REST;

    }
}

