/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.rag.preretrieval.query.transformation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.preretrieval.query.transformation.QueryTransformer;
import org.springframework.ai.util.PromptAssert;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RewriteQueryTransformer
implements QueryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(RewriteQueryTransformer.class);
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = new PromptTemplate("Given a user query, rewrite it to provide better results when querying a {target}.\nRemove any irrelevant information, and ensure the query is concise and specific.\n\nOriginal query:\n{query}\n\nRewritten query:\n");
    private static final String DEFAULT_TARGET = "vector store";
    private final ChatClient chatClient;
    private final PromptTemplate promptTemplate;
    private final String targetSearchSystem;

    public RewriteQueryTransformer(ChatClient.Builder chatClientBuilder, @Nullable PromptTemplate promptTemplate, @Nullable String targetSearchSystem) {
        Assert.notNull((Object)chatClientBuilder, (String)"chatClientBuilder cannot be null");
        this.chatClient = chatClientBuilder.build();
        this.promptTemplate = promptTemplate != null ? promptTemplate : DEFAULT_PROMPT_TEMPLATE;
        this.targetSearchSystem = targetSearchSystem != null ? targetSearchSystem : DEFAULT_TARGET;
        PromptAssert.templateHasRequiredPlaceholders((PromptTemplate)this.promptTemplate, (String[])new String[]{"target", "query"});
    }

    @Override
    public Query transform(Query query) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        logger.debug("Rewriting query to optimize for querying a {}.", (Object)this.targetSearchSystem);
        String rewrittenQueryText = this.chatClient.prompt().user(user -> user.text(this.promptTemplate.getTemplate()).param("target", (Object)this.targetSearchSystem).param("query", (Object)query.text())).options(ChatOptions.builder().build()).call().content();
        if (!StringUtils.hasText((String)rewrittenQueryText)) {
            logger.warn("Query rewrite result is null/empty. Returning the input query unchanged.");
            return query;
        }
        return query.mutate().text(rewrittenQueryText).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChatClient.Builder chatClientBuilder;
        @Nullable
        private PromptTemplate promptTemplate;
        @Nullable
        private String targetSearchSystem;

        private Builder() {
        }

        public Builder chatClientBuilder(ChatClient.Builder chatClientBuilder) {
            this.chatClientBuilder = chatClientBuilder;
            return this;
        }

        public Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public Builder targetSearchSystem(String targetSearchSystem) {
            this.targetSearchSystem = targetSearchSystem;
            return this;
        }

        public RewriteQueryTransformer build() {
            return new RewriteQueryTransformer(this.chatClientBuilder, this.promptTemplate, this.targetSearchSystem);
        }
    }
}

