/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.postgresml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.postgresml.PostgresMlEmbeddingModel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostgresMlEmbeddingOptions
implements EmbeddingOptions {
    @JsonProperty(value="transformer")
    private String transformer = "distilbert-base-uncased";
    @JsonProperty(value="vectorType")
    private PostgresMlEmbeddingModel.VectorType vectorType = PostgresMlEmbeddingModel.VectorType.PG_ARRAY;
    @JsonProperty(value="kwargs")
    private Map<String, Object> kwargs = Map.of();
    @JsonProperty(value="metadataMode")
    private MetadataMode metadataMode = MetadataMode.EMBED;

    public static Builder builder() {
        return new Builder();
    }

    public String getTransformer() {
        return this.transformer;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    public PostgresMlEmbeddingModel.VectorType getVectorType() {
        return this.vectorType;
    }

    public void setVectorType(PostgresMlEmbeddingModel.VectorType vectorType) {
        this.vectorType = vectorType;
    }

    public Map<String, Object> getKwargs() {
        return this.kwargs;
    }

    public void setKwargs(Map<String, Object> kwargs) {
        this.kwargs = kwargs;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        this.metadataMode = metadataMode;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Integer getDimensions() {
        return null;
    }

    public static class Builder {
        protected PostgresMlEmbeddingOptions options = new PostgresMlEmbeddingOptions();

        public Builder transformer(String transformer) {
            this.options.setTransformer(transformer);
            return this;
        }

        public Builder vectorType(PostgresMlEmbeddingModel.VectorType vectorType) {
            this.options.setVectorType(vectorType);
            return this;
        }

        public Builder kwargs(String kwargs) {
            this.options.setKwargs(ModelOptionsUtils.objectToMap((Object)kwargs));
            return this;
        }

        public Builder kwargs(Map<String, Object> kwargs) {
            this.options.setKwargs(kwargs);
            return this;
        }

        public Builder metadataMode(MetadataMode metadataMode) {
            this.options.setMetadataMode(metadataMode);
            return this;
        }

        public PostgresMlEmbeddingOptions build() {
            return this.options;
        }
    }
}

