/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.image.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.util.Collection;
import java.util.StringJoiner;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationDocumentation;
import org.springframework.util.CollectionUtils;

public class ImageModelPromptContentObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (!(context instanceof ImageModelObservationContext)) {
            return context;
        }
        ImageModelObservationContext imageModelObservationContext = (ImageModelObservationContext)context;
        if (CollectionUtils.isEmpty((Collection)((ImagePrompt)imageModelObservationContext.getRequest()).getInstructions())) {
            return imageModelObservationContext;
        }
        StringJoiner promptMessagesJoiner = new StringJoiner(", ", "[", "]");
        ((ImagePrompt)imageModelObservationContext.getRequest()).getInstructions().forEach(message -> promptMessagesJoiner.add("\"" + message.getText() + "\""));
        imageModelObservationContext.addHighCardinalityKeyValue(ImageModelObservationDocumentation.HighCardinalityKeyNames.PROMPT.withValue(promptMessagesJoiner.toString()));
        return imageModelObservationContext;
    }
}

