/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.MessageUtils;
import org.springframework.ai.content.Media;
import org.springframework.ai.content.MediaContent;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserMessage
extends AbstractMessage
implements MediaContent {
    protected final List<Media> media;

    public UserMessage(String textContent) {
        this(textContent, new ArrayList<Media>(), Map.of());
    }

    public UserMessage(Resource resource) {
        this(MessageUtils.readResource(resource));
    }

    @Deprecated
    public UserMessage(String textContent, List<Media> media) {
        this(MessageType.USER, textContent, media, Map.of());
    }

    @Deprecated
    public UserMessage(String textContent, Media ... media) {
        this(textContent, Arrays.asList(media));
    }

    @Deprecated
    public UserMessage(String textContent, Collection<Media> media, Map<String, Object> metadata) {
        super(MessageType.USER, textContent, metadata);
        Assert.notNull(media, (String)"media cannot be null");
        Assert.noNullElements(media, (String)"media cannot have null elements");
        this.media = new ArrayList<Media>(media);
    }

    @Deprecated
    public UserMessage(MessageType messageType, String textContent, Collection<Media> media, Map<String, Object> metadata) {
        super(messageType, textContent, metadata);
        Assert.notNull(media, (String)"media data must not be null");
        this.media = new ArrayList<Media>(media);
    }

    public String toString() {
        return "UserMessage{content='" + this.getText() + "', properties=" + String.valueOf(this.metadata) + ", messageType=" + String.valueOf((Object)this.messageType) + "}";
    }

    @Override
    @NonNull
    public String getText() {
        return this.textContent;
    }

    public List<Media> getMedia() {
        return this.media;
    }

    public UserMessage copy() {
        return new UserMessage(this.getText(), List.copyOf(this.getMedia()), Map.copyOf(this.getMetadata()));
    }

    public Builder mutate() {
        return new Builder().text(this.getText()).media(List.copyOf(this.getMedia())).metadata(Map.copyOf(this.getMetadata()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String textContent;
        @Nullable
        private Resource resource;
        private List<Media> media = new ArrayList<Media>();
        private Map<String, Object> metadata = new HashMap<String, Object>();

        public Builder text(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder text(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            return this;
        }

        public Builder media(Media ... media) {
            if (media != null) {
                this.media = Arrays.asList(media);
            }
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public UserMessage build() {
            if (StringUtils.hasText((String)this.textContent) && this.resource != null) {
                throw new IllegalArgumentException("textContent and resource cannot be set at the same time");
            }
            if (this.resource != null) {
                this.textContent = MessageUtils.readResource(this.resource);
            }
            return new UserMessage(this.textContent, this.media, this.metadata);
        }
    }
}

