/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Map;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

public class AsyncMcpToolCallback
implements ToolCallback {
    private final McpAsyncClient asyncMcpClient;
    private final McpSchema.Tool tool;

    public AsyncMcpToolCallback(McpAsyncClient mcpClient, McpSchema.Tool tool) {
        this.asyncMcpClient = mcpClient;
        this.tool = tool;
    }

    public ToolDefinition getToolDefinition() {
        return ToolDefinition.builder().name(this.tool.name()).description(this.tool.description()).inputSchema(ModelOptionsUtils.toJsonString((Object)this.tool.inputSchema())).build();
    }

    public String call(String functionInput) {
        Map arguments = ModelOptionsUtils.jsonToMap((String)functionInput);
        return (String)this.asyncMcpClient.callTool(new McpSchema.CallToolRequest(this.getToolDefinition().name(), arguments)).map(response -> ModelOptionsUtils.toJsonString((Object)response.content())).block();
    }
}

