/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.huggingface.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Info {
    @JsonProperty(value="docker_label")
    private String dockerLabel = null;
    @JsonProperty(value="max_batch_total_tokens")
    private Integer maxBatchTotalTokens = null;
    @JsonProperty(value="max_best_of")
    private Integer maxBestOf = null;
    @JsonProperty(value="max_concurrent_requests")
    private Integer maxConcurrentRequests = null;
    @JsonProperty(value="max_input_length")
    private Integer maxInputLength = null;
    @JsonProperty(value="max_stop_sequences")
    private Integer maxStopSequences = null;
    @JsonProperty(value="max_total_tokens")
    private Integer maxTotalTokens = null;
    @JsonProperty(value="max_waiting_tokens")
    private Integer maxWaitingTokens = null;
    @JsonProperty(value="model_device_type")
    private String modelDeviceType = null;
    @JsonProperty(value="model_dtype")
    private String modelDtype = null;
    @JsonProperty(value="model_id")
    private String modelId = null;
    @JsonProperty(value="model_pipeline_tag")
    private String modelPipelineTag = null;
    @JsonProperty(value="model_sha")
    private String modelSha = null;
    @JsonProperty(value="sha")
    private String sha = null;
    @JsonProperty(value="validation_workers")
    private Integer validationWorkers = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="waiting_served_ratio")
    private Float waitingServedRatio = null;

    public Info dockerLabel(String dockerLabel) {
        this.dockerLabel = dockerLabel;
        return this;
    }

    @Schema(description="")
    public String getDockerLabel() {
        return this.dockerLabel;
    }

    public void setDockerLabel(String dockerLabel) {
        this.dockerLabel = dockerLabel;
    }

    public Info maxBatchTotalTokens(Integer maxBatchTotalTokens) {
        this.maxBatchTotalTokens = maxBatchTotalTokens;
        return this;
    }

    @Schema(example="32000", required=true, description="")
    public Integer getMaxBatchTotalTokens() {
        return this.maxBatchTotalTokens;
    }

    public void setMaxBatchTotalTokens(Integer maxBatchTotalTokens) {
        this.maxBatchTotalTokens = maxBatchTotalTokens;
    }

    public Info maxBestOf(Integer maxBestOf) {
        this.maxBestOf = maxBestOf;
        return this;
    }

    @Schema(example="2", required=true, description="")
    public Integer getMaxBestOf() {
        return this.maxBestOf;
    }

    public void setMaxBestOf(Integer maxBestOf) {
        this.maxBestOf = maxBestOf;
    }

    public Info maxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    @Schema(example="128", required=true, description="Router Parameters")
    public Integer getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public void setMaxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public Info maxInputLength(Integer maxInputLength) {
        this.maxInputLength = maxInputLength;
        return this;
    }

    @Schema(example="1024", required=true, description="")
    public Integer getMaxInputLength() {
        return this.maxInputLength;
    }

    public void setMaxInputLength(Integer maxInputLength) {
        this.maxInputLength = maxInputLength;
    }

    public Info maxStopSequences(Integer maxStopSequences) {
        this.maxStopSequences = maxStopSequences;
        return this;
    }

    @Schema(example="4", required=true, description="")
    public Integer getMaxStopSequences() {
        return this.maxStopSequences;
    }

    public void setMaxStopSequences(Integer maxStopSequences) {
        this.maxStopSequences = maxStopSequences;
    }

    public Info maxTotalTokens(Integer maxTotalTokens) {
        this.maxTotalTokens = maxTotalTokens;
        return this;
    }

    @Schema(example="2048", required=true, description="")
    public Integer getMaxTotalTokens() {
        return this.maxTotalTokens;
    }

    public void setMaxTotalTokens(Integer maxTotalTokens) {
        this.maxTotalTokens = maxTotalTokens;
    }

    public Info maxWaitingTokens(Integer maxWaitingTokens) {
        this.maxWaitingTokens = maxWaitingTokens;
        return this;
    }

    @Schema(example="20", required=true, description="")
    public Integer getMaxWaitingTokens() {
        return this.maxWaitingTokens;
    }

    public void setMaxWaitingTokens(Integer maxWaitingTokens) {
        this.maxWaitingTokens = maxWaitingTokens;
    }

    public Info modelDeviceType(String modelDeviceType) {
        this.modelDeviceType = modelDeviceType;
        return this;
    }

    @Schema(example="cuda", required=true, description="")
    public String getModelDeviceType() {
        return this.modelDeviceType;
    }

    public void setModelDeviceType(String modelDeviceType) {
        this.modelDeviceType = modelDeviceType;
    }

    public Info modelDtype(String modelDtype) {
        this.modelDtype = modelDtype;
        return this;
    }

    @Schema(example="torch.float16", required=true, description="")
    public String getModelDtype() {
        return this.modelDtype;
    }

    public void setModelDtype(String modelDtype) {
        this.modelDtype = modelDtype;
    }

    public Info modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    @Schema(example="bigscience/blomm-560m", required=true, description="Model info")
    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public Info modelPipelineTag(String modelPipelineTag) {
        this.modelPipelineTag = modelPipelineTag;
        return this;
    }

    @Schema(example="text-generation", description="")
    public String getModelPipelineTag() {
        return this.modelPipelineTag;
    }

    public void setModelPipelineTag(String modelPipelineTag) {
        this.modelPipelineTag = modelPipelineTag;
    }

    public Info modelSha(String modelSha) {
        this.modelSha = modelSha;
        return this;
    }

    @Schema(example="e985a63cdc139290c5f700ff1929f0b5942cced2", description="")
    public String getModelSha() {
        return this.modelSha;
    }

    public void setModelSha(String modelSha) {
        this.modelSha = modelSha;
    }

    public Info sha(String sha) {
        this.sha = sha;
        return this;
    }

    @Schema(description="")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public Info validationWorkers(Integer validationWorkers) {
        this.validationWorkers = validationWorkers;
        return this;
    }

    @Schema(example="2", required=true, description="")
    public Integer getValidationWorkers() {
        return this.validationWorkers;
    }

    public void setValidationWorkers(Integer validationWorkers) {
        this.validationWorkers = validationWorkers;
    }

    public Info version(String version) {
        this.version = version;
        return this;
    }

    @Schema(example="0.5.0", required=true, description="Router Info")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Info waitingServedRatio(Float waitingServedRatio) {
        this.waitingServedRatio = waitingServedRatio;
        return this;
    }

    @Schema(example="1.2", required=true, description="")
    public Float getWaitingServedRatio() {
        return this.waitingServedRatio;
    }

    public void setWaitingServedRatio(Float waitingServedRatio) {
        this.waitingServedRatio = waitingServedRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info info = (Info)o;
        return Objects.equals(this.dockerLabel, info.dockerLabel) && Objects.equals(this.maxBatchTotalTokens, info.maxBatchTotalTokens) && Objects.equals(this.maxBestOf, info.maxBestOf) && Objects.equals(this.maxConcurrentRequests, info.maxConcurrentRequests) && Objects.equals(this.maxInputLength, info.maxInputLength) && Objects.equals(this.maxStopSequences, info.maxStopSequences) && Objects.equals(this.maxTotalTokens, info.maxTotalTokens) && Objects.equals(this.maxWaitingTokens, info.maxWaitingTokens) && Objects.equals(this.modelDeviceType, info.modelDeviceType) && Objects.equals(this.modelDtype, info.modelDtype) && Objects.equals(this.modelId, info.modelId) && Objects.equals(this.modelPipelineTag, info.modelPipelineTag) && Objects.equals(this.modelSha, info.modelSha) && Objects.equals(this.sha, info.sha) && Objects.equals(this.validationWorkers, info.validationWorkers) && Objects.equals(this.version, info.version) && Objects.equals(this.waitingServedRatio, info.waitingServedRatio);
    }

    public int hashCode() {
        return Objects.hash(this.dockerLabel, this.maxBatchTotalTokens, this.maxBestOf, this.maxConcurrentRequests, this.maxInputLength, this.maxStopSequences, this.maxTotalTokens, this.maxWaitingTokens, this.modelDeviceType, this.modelDtype, this.modelId, this.modelPipelineTag, this.modelSha, this.sha, this.validationWorkers, this.version, this.waitingServedRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Info {\n");
        sb.append("    dockerLabel: ").append(this.toIndentedString(this.dockerLabel)).append("\n");
        sb.append("    maxBatchTotalTokens: ").append(this.toIndentedString(this.maxBatchTotalTokens)).append("\n");
        sb.append("    maxBestOf: ").append(this.toIndentedString(this.maxBestOf)).append("\n");
        sb.append("    maxConcurrentRequests: ").append(this.toIndentedString(this.maxConcurrentRequests)).append("\n");
        sb.append("    maxInputLength: ").append(this.toIndentedString(this.maxInputLength)).append("\n");
        sb.append("    maxStopSequences: ").append(this.toIndentedString(this.maxStopSequences)).append("\n");
        sb.append("    maxTotalTokens: ").append(this.toIndentedString(this.maxTotalTokens)).append("\n");
        sb.append("    maxWaitingTokens: ").append(this.toIndentedString(this.maxWaitingTokens)).append("\n");
        sb.append("    modelDeviceType: ").append(this.toIndentedString(this.modelDeviceType)).append("\n");
        sb.append("    modelDtype: ").append(this.toIndentedString(this.modelDtype)).append("\n");
        sb.append("    modelId: ").append(this.toIndentedString(this.modelId)).append("\n");
        sb.append("    modelPipelineTag: ").append(this.toIndentedString(this.modelPipelineTag)).append("\n");
        sb.append("    modelSha: ").append(this.toIndentedString(this.modelSha)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    validationWorkers: ").append(this.toIndentedString(this.validationWorkers)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    waitingServedRatio: ").append(this.toIndentedString(this.waitingServedRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

