/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.huggingface.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GenerateParameters {
    @JsonProperty(value="best_of")
    private Integer bestOf = null;
    @JsonProperty(value="decoder_input_details")
    private Boolean decoderInputDetails = true;
    @JsonProperty(value="details")
    private Boolean details = true;
    @JsonProperty(value="do_sample")
    private Boolean doSample = false;
    @JsonProperty(value="max_new_tokens")
    private Integer maxNewTokens = null;
    @JsonProperty(value="repetition_penalty")
    private Float repetitionPenalty = null;
    @JsonProperty(value="return_full_text")
    private Boolean returnFullText = false;
    @JsonProperty(value="seed")
    private Long seed = null;
    @JsonProperty(value="stop")
    private List<String> stop = null;
    @JsonProperty(value="temperature")
    private Float temperature = null;
    @JsonProperty(value="top_k")
    private Integer topK = null;
    @JsonProperty(value="top_p")
    private Float topP = null;
    @JsonProperty(value="truncate")
    private Integer truncate = null;
    @JsonProperty(value="typical_p")
    private Float typicalP = null;
    @JsonProperty(value="watermark")
    private Boolean watermark = false;

    public GenerateParameters bestOf(Integer bestOf) {
        this.bestOf = bestOf;
        return this;
    }

    @Schema(example="1", description="")
    public Integer getBestOf() {
        return this.bestOf;
    }

    public void setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
    }

    public GenerateParameters decoderInputDetails(Boolean decoderInputDetails) {
        this.decoderInputDetails = decoderInputDetails;
        return this;
    }

    @Schema(description="")
    public Boolean isDecoderInputDetails() {
        return this.decoderInputDetails;
    }

    public void setDecoderInputDetails(Boolean decoderInputDetails) {
        this.decoderInputDetails = decoderInputDetails;
    }

    public GenerateParameters details(Boolean details) {
        this.details = details;
        return this;
    }

    @Schema(description="")
    public Boolean isDetails() {
        return this.details;
    }

    public void setDetails(Boolean details) {
        this.details = details;
    }

    public GenerateParameters doSample(Boolean doSample) {
        this.doSample = doSample;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isDoSample() {
        return this.doSample;
    }

    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    public GenerateParameters maxNewTokens(Integer maxNewTokens) {
        this.maxNewTokens = maxNewTokens;
        return this;
    }

    @Schema(description="")
    public Integer getMaxNewTokens() {
        return this.maxNewTokens;
    }

    public void setMaxNewTokens(Integer maxNewTokens) {
        this.maxNewTokens = maxNewTokens;
    }

    public GenerateParameters repetitionPenalty(Float repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
        return this;
    }

    @Schema(example="1.03", description="")
    public Float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public void setRepetitionPenalty(Float repetitionPenalty) {
        this.repetitionPenalty = repetitionPenalty;
    }

    public GenerateParameters returnFullText(Boolean returnFullText) {
        this.returnFullText = returnFullText;
        return this;
    }

    @Schema(example="false", description="")
    public Boolean isReturnFullText() {
        return this.returnFullText;
    }

    public void setReturnFullText(Boolean returnFullText) {
        this.returnFullText = returnFullText;
    }

    public GenerateParameters seed(Long seed) {
        this.seed = seed;
        return this;
    }

    @Schema(description="")
    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public GenerateParameters stop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public GenerateParameters addStopItem(String stopItem) {
        if (this.stop == null) {
            this.stop = new ArrayList<String>();
        }
        this.stop.add(stopItem);
        return this;
    }

    @Schema(example="[\"photographer\"]", description="")
    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public GenerateParameters temperature(Float temperature) {
        this.temperature = temperature;
        return this;
    }

    @Schema(example="0.5", description="")
    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public GenerateParameters topK(Integer topK) {
        this.topK = topK;
        return this;
    }

    @Schema(example="10", description="")
    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public GenerateParameters topP(Float topP) {
        this.topP = topP;
        return this;
    }

    @Schema(example="0.95", description="")
    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public GenerateParameters truncate(Integer truncate) {
        this.truncate = truncate;
        return this;
    }

    @Schema(description="")
    public Integer getTruncate() {
        return this.truncate;
    }

    public void setTruncate(Integer truncate) {
        this.truncate = truncate;
    }

    public GenerateParameters typicalP(Float typicalP) {
        this.typicalP = typicalP;
        return this;
    }

    @Schema(example="0.95", description="")
    public Float getTypicalP() {
        return this.typicalP;
    }

    public void setTypicalP(Float typicalP) {
        this.typicalP = typicalP;
    }

    public GenerateParameters watermark(Boolean watermark) {
        this.watermark = watermark;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isWatermark() {
        return this.watermark;
    }

    public void setWatermark(Boolean watermark) {
        this.watermark = watermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateParameters generateParameters = (GenerateParameters)o;
        return Objects.equals(this.bestOf, generateParameters.bestOf) && Objects.equals(this.decoderInputDetails, generateParameters.decoderInputDetails) && Objects.equals(this.details, generateParameters.details) && Objects.equals(this.doSample, generateParameters.doSample) && Objects.equals(this.maxNewTokens, generateParameters.maxNewTokens) && Objects.equals(this.repetitionPenalty, generateParameters.repetitionPenalty) && Objects.equals(this.returnFullText, generateParameters.returnFullText) && Objects.equals(this.seed, generateParameters.seed) && Objects.equals(this.stop, generateParameters.stop) && Objects.equals(this.temperature, generateParameters.temperature) && Objects.equals(this.topK, generateParameters.topK) && Objects.equals(this.topP, generateParameters.topP) && Objects.equals(this.truncate, generateParameters.truncate) && Objects.equals(this.typicalP, generateParameters.typicalP) && Objects.equals(this.watermark, generateParameters.watermark);
    }

    public int hashCode() {
        return Objects.hash(this.bestOf, this.decoderInputDetails, this.details, this.doSample, this.maxNewTokens, this.repetitionPenalty, this.returnFullText, this.seed, this.stop, this.temperature, this.topK, this.topP, this.truncate, this.typicalP, this.watermark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateParameters {\n");
        sb.append("    bestOf: ").append(this.toIndentedString(this.bestOf)).append("\n");
        sb.append("    decoderInputDetails: ").append(this.toIndentedString(this.decoderInputDetails)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    doSample: ").append(this.toIndentedString(this.doSample)).append("\n");
        sb.append("    maxNewTokens: ").append(this.toIndentedString(this.maxNewTokens)).append("\n");
        sb.append("    repetitionPenalty: ").append(this.toIndentedString(this.repetitionPenalty)).append("\n");
        sb.append("    returnFullText: ").append(this.toIndentedString(this.returnFullText)).append("\n");
        sb.append("    seed: ").append(this.toIndentedString(this.seed)).append("\n");
        sb.append("    stop: ").append(this.toIndentedString(this.stop)).append("\n");
        sb.append("    temperature: ").append(this.toIndentedString(this.temperature)).append("\n");
        sb.append("    topK: ").append(this.toIndentedString(this.topK)).append("\n");
        sb.append("    topP: ").append(this.toIndentedString(this.topP)).append("\n");
        sb.append("    truncate: ").append(this.toIndentedString(this.truncate)).append("\n");
        sb.append("    typicalP: ").append(this.toIndentedString(this.typicalP)).append("\n");
        sb.append("    watermark: ").append(this.toIndentedString(this.watermark)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

