/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIAsyncClient;
import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.accesshelpers.ChatCompletionsOptionsAccessHelper;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletionStreamOptions;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinition;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolDefinitionFunction;
import com.azure.ai.openai.models.ChatCompletionsJsonResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsJsonSchemaResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsJsonSchemaResponseFormatJsonSchema;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsTextResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolDefinition;
import com.azure.ai.openai.models.ChatMessageImageContentItem;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.ai.openai.models.ChatMessageTextContentItem;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.ai.openai.models.ReasoningEffortValue;
import com.azure.core.util.BinaryData;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.azure.openai.AzureOpenAiChatOptions;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.azure.openai.MergeUtils;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.PromptMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AzureOpenAiChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiChatModel.class);
    private static final String DEFAULT_DEPLOYMENT_NAME = "gpt-4o";
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final OpenAIClient openAIClient;
    private final OpenAIAsyncClient openAIAsyncClient;
    private final AzureOpenAiChatOptions defaultOptions;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions defaultOptions, ToolCallingManager toolCallingManager, ObservationRegistry observationRegistry) {
        this(openAIClientBuilder, defaultOptions, toolCallingManager, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public AzureOpenAiChatModel(OpenAIClientBuilder openAIClientBuilder, AzureOpenAiChatOptions defaultOptions, ToolCallingManager toolCallingManager, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)openAIClientBuilder, (String)"com.azure.ai.openai.OpenAIClient must not be null");
        Assert.notNull((Object)defaultOptions, (String)"defaultOptions cannot be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.openAIClient = openAIClientBuilder.buildClient();
        this.openAIAsyncClient = openAIClientBuilder.buildAsyncClient();
        this.defaultOptions = defaultOptions;
        this.toolCallingManager = toolCallingManager;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    public static ChatResponseMetadata from(ChatCompletions chatCompletions, PromptMetadata promptFilterMetadata, Usage usage) {
        Assert.notNull((Object)chatCompletions, (String)"Azure OpenAI ChatCompletions must not be null");
        String id = chatCompletions.getId();
        return ChatResponseMetadata.builder().id(id).usage(usage).model(chatCompletions.getModel()).promptMetadata(promptFilterMetadata).keyValue("system-fingerprint", (Object)chatCompletions.getSystemFingerprint()).build();
    }

    public static ChatResponseMetadata from(ChatCompletions chatCompletions, PromptMetadata promptFilterMetadata) {
        EmptyUsage usage = chatCompletions.getUsage() != null ? AzureOpenAiChatModel.getDefaultUsage(chatCompletions.getUsage()) : new EmptyUsage();
        return AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata, (Usage)usage);
    }

    public static ChatResponseMetadata from(ChatCompletions chatCompletions, PromptMetadata promptFilterMetadata, CompletionsUsage usage) {
        return AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata, (Usage)AzureOpenAiChatModel.getDefaultUsage(usage));
    }

    public static ChatResponseMetadata from(ChatResponse chatResponse, Usage usage) {
        Assert.notNull((Object)chatResponse, (String)"ChatResponse must not be null");
        ChatResponseMetadata chatResponseMetadata = chatResponse.getMetadata();
        ChatResponseMetadata.Builder builder = ChatResponseMetadata.builder();
        builder.id(chatResponseMetadata.getId()).usage(usage).model(chatResponseMetadata.getModel()).promptMetadata(chatResponseMetadata.getPromptMetadata());
        if (chatResponseMetadata.containsKey((Object)"system-fingerprint")) {
            builder.keyValue("system-fingerprint", chatResponseMetadata.get("system-fingerprint"));
        }
        return builder.build();
    }

    private static DefaultUsage getDefaultUsage(CompletionsUsage usage) {
        return new DefaultUsage(Integer.valueOf(usage.getPromptTokens()), Integer.valueOf(usage.getCompletionTokens()), Integer.valueOf(usage.getTotalTokens()), (Object)usage);
    }

    public AzureOpenAiChatOptions getDefaultOptions() {
        return AzureOpenAiChatOptions.fromOptions(this.defaultOptions);
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.AZURE_OPENAI.value()).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ChatCompletionsOptions options = this.toAzureChatCompletionsOptions(prompt);
            ChatCompletionsOptionsAccessHelper.setStream((ChatCompletionsOptions)options, (boolean)false);
            ChatCompletions chatCompletions = this.openAIClient.getChatCompletions(options.getModel(), options);
            ChatResponse chatResponse = this.toChatResponse(chatCompletions, previousChatResponse);
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            ChatCompletionsOptions options = this.toAzureChatCompletionsOptions(prompt);
            ChatCompletionsOptionsAccessHelper.setStream((ChatCompletionsOptions)options, (boolean)true);
            Flux chatCompletionsStream = this.openAIAsyncClient.getChatCompletionsStream(options.getModel(), options);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.AZURE_OPENAI.value()).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            AtomicBoolean isFunctionCall = new AtomicBoolean(false);
            Flux accessibleChatCompletionsFlux = chatCompletionsStream.filter(chatCompletions -> !CollectionUtils.isEmpty((Collection)chatCompletions.getChoices()) || chatCompletions.getUsage() != null).map(chatCompletions -> {
                if (!chatCompletions.getChoices().isEmpty()) {
                    ChatChoice chatChoice = (ChatChoice)chatCompletions.getChoices().get(0);
                    List toolCalls = null;
                    if (chatChoice.getDelta() != null) {
                        toolCalls = chatChoice.getDelta().getToolCalls();
                    }
                    isFunctionCall.set(toolCalls != null && !toolCalls.isEmpty());
                }
                return chatCompletions;
            }).windowUntil(chatCompletions -> {
                if (isFunctionCall.get() && ((ChatChoice)chatCompletions.getChoices().get(0)).getFinishReason() == CompletionsFinishReason.TOOL_CALLS) {
                    isFunctionCall.set(false);
                    return true;
                }
                return !isFunctionCall.get();
            }).concatMapIterable(window -> {
                Mono reduce = window.reduce((Object)MergeUtils.emptyChatCompletions(), MergeUtils::mergeChatCompletions);
                return List.of(reduce);
            }).flatMap(mono -> mono);
            Flux chatResponseFlux = accessibleChatCompletionsFlux.map(chatCompletion -> {
                if (previousChatResponse == null) {
                    return this.toChatResponse((ChatCompletions)chatCompletion);
                }
                CompletionsUsage usage = chatCompletion.getUsage();
                DefaultUsage currentChatResponseUsage = usage != null ? AzureOpenAiChatModel.getDefaultUsage(usage) : new EmptyUsage();
                Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
                return this.toChatResponse((ChatCompletions)chatCompletion, accumulatedUsage);
            }).buffer(2, 1).map(bufferList -> {
                ChatResponse chatResponse2;
                ChatResponse chatResponse1 = (ChatResponse)bufferList.get(0);
                if (options.getStreamOptions() != null && options.getStreamOptions().isIncludeUsage().booleanValue() && bufferList.size() == 2 && (chatResponse2 = (ChatResponse)bufferList.get(1)) != null && chatResponse2.getMetadata() != null && !UsageCalculator.isEmpty((Usage)chatResponse2.getMetadata().getUsage())) {
                    return this.toChatResponse(chatResponse1, chatResponse2.getMetadata().getUsage());
                }
                return chatResponse1;
            });
            return chatResponseFlux.flatMap(chatResponse -> {
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), chatResponse)) {
                    return Flux.defer(() -> {
                        ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, chatResponse);
                        if (toolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(chatResponse).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                        }
                        return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)chatResponse);
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                Flux flux = Flux.just((Object)chatResponse).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
            });
        });
    }

    private ChatResponse toChatResponse(ChatCompletions chatCompletions) {
        List<Generation> generations = this.nullSafeList(chatCompletions.getChoices()).stream().map(choice -> {
            Map<String, Object> metadata = Map.of("id", chatCompletions.getId() != null ? chatCompletions.getId() : "", "choiceIndex", choice.getIndex(), "finishReason", choice.getFinishReason() != null ? String.valueOf(choice.getFinishReason()) : "");
            return this.buildGeneration((ChatChoice)choice, metadata);
        }).toList();
        PromptMetadata promptFilterMetadata = this.generatePromptMetadata(chatCompletions);
        return new ChatResponse(generations, AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata));
    }

    private ChatResponse toChatResponse(ChatCompletions chatCompletions, Usage usage) {
        List<Generation> generations = this.nullSafeList(chatCompletions.getChoices()).stream().map(choice -> {
            Map<String, Object> metadata = Map.of("id", chatCompletions.getId() != null ? chatCompletions.getId() : "", "choiceIndex", choice.getIndex(), "finishReason", choice.getFinishReason() != null ? String.valueOf(choice.getFinishReason()) : "");
            return this.buildGeneration((ChatChoice)choice, metadata);
        }).toList();
        PromptMetadata promptFilterMetadata = this.generatePromptMetadata(chatCompletions);
        return new ChatResponse(generations, AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata, usage));
    }

    private ChatResponse toChatResponse(ChatResponse chatResponse, Usage usage) {
        return new ChatResponse(chatResponse.getResults(), AzureOpenAiChatModel.from(chatResponse, usage));
    }

    private ChatResponse toChatResponse(ChatCompletions chatCompletions, ChatResponse previousChatResponse) {
        List<Generation> generations = this.nullSafeList(chatCompletions.getChoices()).stream().map(choice -> {
            Map<String, Object> metadata = Map.of("id", chatCompletions.getId() != null ? chatCompletions.getId() : "", "choiceIndex", choice.getIndex(), "finishReason", choice.getFinishReason() != null ? String.valueOf(choice.getFinishReason()) : "");
            return this.buildGeneration((ChatChoice)choice, metadata);
        }).toList();
        PromptMetadata promptFilterMetadata = this.generatePromptMetadata(chatCompletions);
        DefaultUsage currentUsage = null;
        if (chatCompletions.getUsage() != null) {
            currentUsage = AzureOpenAiChatModel.getDefaultUsage(chatCompletions.getUsage());
        }
        Usage cumulativeUsage = UsageCalculator.getCumulativeUsage(currentUsage, (ChatResponse)previousChatResponse);
        return new ChatResponse(generations, AzureOpenAiChatModel.from(chatCompletions, promptFilterMetadata, cumulativeUsage));
    }

    private Generation buildGeneration(ChatChoice choice, Map<String, Object> metadata) {
        ChatResponseMessage responseMessage = Optional.ofNullable(choice.getMessage()).orElse(choice.getDelta());
        List<Object> toolCalls = List.of();
        if (responseMessage != null && responseMessage.getToolCalls() != null) {
            toolCalls = responseMessage.getToolCalls().stream().map(toolCall -> {
                ChatCompletionsFunctionToolCall tc1 = (ChatCompletionsFunctionToolCall)toolCall;
                String id = tc1.getId();
                String name = tc1.getFunction().getName();
                String arguments = tc1.getFunction().getArguments();
                return new AssistantMessage.ToolCall(id, "function", name, arguments);
            }).toList();
        }
        String content = responseMessage == null ? "" : responseMessage.getContent();
        AssistantMessage assistantMessage = new AssistantMessage(content, metadata, toolCalls);
        ChatGenerationMetadata generationMetadata = this.generateChoiceMetadata(choice);
        return new Generation(assistantMessage, generationMetadata);
    }

    ChatCompletionsOptions toAzureChatCompletionsOptions(Prompt prompt) {
        AzureOpenAiChatOptions azureOpenAiChatOptions;
        ChatOptions chatOptions;
        Boolean enableStreamUsage;
        ArrayList<ToolDefinition> functionsForThisRequest = new ArrayList<ToolDefinition>();
        List azureMessages = prompt.getInstructions().stream().map(this::fromSpringAiMessage).flatMap(Collection::stream).toList();
        ChatCompletionsOptions options = new ChatCompletionsOptions(azureMessages);
        options = this.merge(options, this.defaultOptions);
        if (prompt.getOptions() != null) {
            AzureOpenAiChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions2 = prompt.getOptions();
            if (chatOptions2 instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions2;
                updatedRuntimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, AzureOpenAiChatOptions.class);
            } else {
                updatedRuntimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AzureOpenAiChatOptions.class);
            }
            options = this.merge(updatedRuntimeOptions, options);
            functionsForThisRequest.addAll(this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)updatedRuntimeOptions));
        }
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            List<ChatCompletionsFunctionToolDefinition> tools = this.getFunctionTools(functionsForThisRequest);
            List<ChatCompletionsToolDefinition> tools2 = tools.stream().map(t -> t).toList();
            options.setTools(tools2);
        }
        Boolean bl = enableStreamUsage = (chatOptions = prompt.getOptions()) instanceof AzureOpenAiChatOptions && (azureOpenAiChatOptions = (AzureOpenAiChatOptions)chatOptions).getStreamUsage() != null ? azureOpenAiChatOptions.getStreamUsage() : this.defaultOptions.getStreamUsage();
        if (Boolean.TRUE.equals(enableStreamUsage) && options.getStreamOptions() == null) {
            ChatCompletionsOptionsAccessHelper.setStreamOptions((ChatCompletionsOptions)options, (ChatCompletionStreamOptions)new ChatCompletionStreamOptions().setIncludeUsage(Boolean.valueOf(true)));
        }
        return options;
    }

    private List<ChatCompletionsFunctionToolDefinition> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            ChatCompletionsFunctionToolDefinitionFunction functionDefinition = new ChatCompletionsFunctionToolDefinitionFunction(toolDefinition.name());
            functionDefinition.setDescription(toolDefinition.description());
            BinaryData parameters = BinaryData.fromObject((Object)ModelOptionsUtils.jsonToMap((String)toolDefinition.inputSchema()));
            functionDefinition.setParameters(parameters);
            return new ChatCompletionsFunctionToolDefinition(functionDefinition);
        }).toList();
    }

    private List<ChatRequestMessage> fromSpringAiMessage(Message message) {
        switch (message.getMessageType()) {
            case USER: {
                UserMessage userMessage;
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(new ChatMessageTextContentItem(message.getText()));
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    items.addAll(userMessage.getMedia().stream().map(media -> new ChatMessageImageContentItem(new ChatMessageImageUrl(this.getMediaUrl((Media)media)))).toList());
                }
                return List.of(new ChatRequestUserMessage(items));
            }
            case SYSTEM: {
                return List.of(new ChatRequestSystemMessage(message.getText()));
            }
            case ASSISTANT: {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<ChatCompletionsToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        FunctionCall function = new FunctionCall(toolCall.name(), toolCall.arguments());
                        return new ChatCompletionsFunctionToolCall(toolCall.id(), function);
                    }).map(tc -> tc).toList();
                }
                ChatRequestAssistantMessage azureAssistantMessage = new ChatRequestAssistantMessage(message.getText());
                azureAssistantMessage.setToolCalls(toolCalls);
                return List.of(azureAssistantMessage);
            }
            case TOOL: {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new ChatRequestToolMessage(tr.responseData(), tr.id())).map(crtm -> crtm).toList();
            }
        }
        throw new IllegalArgumentException("Unknown message type " + String.valueOf(message.getMessageType()));
    }

    private String getMediaUrl(Media media) {
        Object data = media.getData();
        if (data instanceof String) {
            String dataUrl = (String)data;
            return dataUrl;
        }
        if (data instanceof byte[]) {
            byte[] dataBytes = (byte[])data;
            String base64EncodedData = Base64.getEncoder().encodeToString(dataBytes);
            return "data:" + String.valueOf(media.getMimeType()) + ";base64," + base64EncodedData;
        }
        throw new IllegalArgumentException("Unknown media data type " + data.getClass().getName());
    }

    private ChatGenerationMetadata generateChoiceMetadata(ChatChoice choice) {
        return ChatGenerationMetadata.builder().finishReason(String.valueOf(choice.getFinishReason())).metadata("contentFilterResults", (Object)choice.getContentFilterResults()).metadata("logprobs", (Object)choice.getLogprobs()).build();
    }

    private PromptMetadata generatePromptMetadata(ChatCompletions chatCompletions) {
        List promptFilterResults = this.nullSafeList(chatCompletions.getPromptFilterResults());
        return PromptMetadata.of(promptFilterResults.stream().map(promptFilterResult -> PromptMetadata.PromptFilterMetadata.from((int)promptFilterResult.getPromptIndex(), (Object)promptFilterResult.getContentFilterResults())).toList());
    }

    private <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        AzureOpenAiChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, AzureOpenAiChatOptions.class);
            } else {
                runtimeOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AzureOpenAiChatOptions.class);
            }
        }
        AzureOpenAiChatOptions requestOptions = (AzureOpenAiChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, AzureOpenAiChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setStreamUsage((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getStreamUsage(), (Object)this.defaultOptions.getStreamUsage()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setStreamUsage(this.defaultOptions.getStreamUsage());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    private ChatCompletionsOptions merge(ChatCompletionsOptions fromAzureOptions, AzureOpenAiChatOptions toSpringAiOptions) {
        ReasoningEffortValue reasoningEffort;
        if (toSpringAiOptions == null) {
            return fromAzureOptions;
        }
        ChatCompletionsOptions mergedAzureOptions = new ChatCompletionsOptions(fromAzureOptions.getMessages());
        ChatCompletionsOptionsAccessHelper.setStream((ChatCompletionsOptions)mergedAzureOptions, (boolean)(fromAzureOptions.isStream() != null ? fromAzureOptions.isStream() : false));
        ChatCompletionsOptionsAccessHelper.setStreamOptions((ChatCompletionsOptions)mergedAzureOptions, (ChatCompletionStreamOptions)(fromAzureOptions.getStreamOptions() != null ? fromAzureOptions.getStreamOptions() : toSpringAiOptions.getStreamOptions()));
        mergedAzureOptions.setMaxTokens(fromAzureOptions.getMaxTokens() != null ? fromAzureOptions.getMaxTokens() : toSpringAiOptions.getMaxTokens());
        mergedAzureOptions.setLogitBias(fromAzureOptions.getLogitBias() != null ? fromAzureOptions.getLogitBias() : toSpringAiOptions.getLogitBias());
        mergedAzureOptions.setStop(fromAzureOptions.getStop() != null ? fromAzureOptions.getStop() : toSpringAiOptions.getStop());
        mergedAzureOptions.setTemperature(fromAzureOptions.getTemperature());
        if (mergedAzureOptions.getTemperature() == null && toSpringAiOptions.getTemperature() != null) {
            mergedAzureOptions.setTemperature(toSpringAiOptions.getTemperature());
        }
        mergedAzureOptions.setTopP(fromAzureOptions.getTopP());
        if (mergedAzureOptions.getTopP() == null && toSpringAiOptions.getTopP() != null) {
            mergedAzureOptions.setTopP(toSpringAiOptions.getTopP());
        }
        mergedAzureOptions.setFrequencyPenalty(fromAzureOptions.getFrequencyPenalty());
        if (mergedAzureOptions.getFrequencyPenalty() == null && toSpringAiOptions.getFrequencyPenalty() != null) {
            mergedAzureOptions.setFrequencyPenalty(toSpringAiOptions.getFrequencyPenalty());
        }
        mergedAzureOptions.setPresencePenalty(fromAzureOptions.getPresencePenalty());
        if (mergedAzureOptions.getPresencePenalty() == null && toSpringAiOptions.getPresencePenalty() != null) {
            mergedAzureOptions.setPresencePenalty(toSpringAiOptions.getPresencePenalty());
        }
        mergedAzureOptions.setResponseFormat(fromAzureOptions.getResponseFormat());
        if (mergedAzureOptions.getResponseFormat() == null && toSpringAiOptions.getResponseFormat() != null) {
            mergedAzureOptions.setResponseFormat(this.toAzureResponseFormat(toSpringAiOptions.getResponseFormat()));
        }
        mergedAzureOptions.setN(fromAzureOptions.getN() != null ? fromAzureOptions.getN() : toSpringAiOptions.getN());
        mergedAzureOptions.setUser(fromAzureOptions.getUser() != null ? fromAzureOptions.getUser() : toSpringAiOptions.getUser());
        mergedAzureOptions.setModel(fromAzureOptions.getModel() != null ? fromAzureOptions.getModel() : toSpringAiOptions.getDeploymentName());
        mergedAzureOptions.setSeed(fromAzureOptions.getSeed() != null ? fromAzureOptions.getSeed() : toSpringAiOptions.getSeed());
        mergedAzureOptions.setLogprobs(Boolean.valueOf(fromAzureOptions.isLogprobs() != null && fromAzureOptions.isLogprobs() != false || toSpringAiOptions.isLogprobs() != null && toSpringAiOptions.isLogprobs() != false));
        mergedAzureOptions.setTopLogprobs(fromAzureOptions.getTopLogprobs() != null ? fromAzureOptions.getTopLogprobs() : toSpringAiOptions.getTopLogProbs());
        mergedAzureOptions.setEnhancements(fromAzureOptions.getEnhancements() != null ? fromAzureOptions.getEnhancements() : toSpringAiOptions.getEnhancements());
        Object object = fromAzureOptions.getReasoningEffort() != null ? fromAzureOptions.getReasoningEffort() : (reasoningEffort = StringUtils.hasText((String)toSpringAiOptions.getReasoningEffort()) ? ReasoningEffortValue.fromString((String)toSpringAiOptions.getReasoningEffort()) : null);
        if (reasoningEffort != null) {
            mergedAzureOptions.setReasoningEffort(reasoningEffort);
        }
        return mergedAzureOptions;
    }

    private ChatCompletionsOptions merge(AzureOpenAiChatOptions fromSpringAiOptions, ChatCompletionsOptions toAzureOptions) {
        if (fromSpringAiOptions == null) {
            return toAzureOptions;
        }
        ChatCompletionsOptions mergedAzureOptions = this.copy(toAzureOptions);
        if (fromSpringAiOptions.getMaxTokens() != null) {
            mergedAzureOptions.setMaxTokens(fromSpringAiOptions.getMaxTokens());
        }
        if (fromSpringAiOptions.getLogitBias() != null) {
            mergedAzureOptions.setLogitBias(fromSpringAiOptions.getLogitBias());
        }
        if (fromSpringAiOptions.getStop() != null) {
            mergedAzureOptions.setStop(fromSpringAiOptions.getStop());
        }
        if (fromSpringAiOptions.getTemperature() != null) {
            mergedAzureOptions.setTemperature(fromSpringAiOptions.getTemperature());
        }
        if (fromSpringAiOptions.getTopP() != null) {
            mergedAzureOptions.setTopP(fromSpringAiOptions.getTopP());
        }
        if (fromSpringAiOptions.getFrequencyPenalty() != null) {
            mergedAzureOptions.setFrequencyPenalty(fromSpringAiOptions.getFrequencyPenalty());
        }
        if (fromSpringAiOptions.getPresencePenalty() != null) {
            mergedAzureOptions.setPresencePenalty(fromSpringAiOptions.getPresencePenalty());
        }
        if (fromSpringAiOptions.getN() != null) {
            mergedAzureOptions.setN(fromSpringAiOptions.getN());
        }
        if (fromSpringAiOptions.getUser() != null) {
            mergedAzureOptions.setUser(fromSpringAiOptions.getUser());
        }
        if (fromSpringAiOptions.getDeploymentName() != null) {
            mergedAzureOptions.setModel(fromSpringAiOptions.getDeploymentName());
        }
        if (fromSpringAiOptions.getResponseFormat() != null) {
            mergedAzureOptions.setResponseFormat(this.toAzureResponseFormat(fromSpringAiOptions.getResponseFormat()));
        }
        if (fromSpringAiOptions.getSeed() != null) {
            mergedAzureOptions.setSeed(fromSpringAiOptions.getSeed());
        }
        if (fromSpringAiOptions.isLogprobs() != null) {
            mergedAzureOptions.setLogprobs(fromSpringAiOptions.isLogprobs());
        }
        if (fromSpringAiOptions.getTopLogProbs() != null) {
            mergedAzureOptions.setTopLogprobs(fromSpringAiOptions.getTopLogProbs());
        }
        if (fromSpringAiOptions.getEnhancements() != null) {
            mergedAzureOptions.setEnhancements(fromSpringAiOptions.getEnhancements());
        }
        if (fromSpringAiOptions.getStreamOptions() != null) {
            ChatCompletionsOptionsAccessHelper.setStreamOptions((ChatCompletionsOptions)mergedAzureOptions, (ChatCompletionStreamOptions)fromSpringAiOptions.getStreamOptions());
        }
        if (fromSpringAiOptions.getEnhancements() != null) {
            mergedAzureOptions.setEnhancements(fromSpringAiOptions.getEnhancements());
        }
        if (StringUtils.hasText((String)fromSpringAiOptions.getReasoningEffort())) {
            mergedAzureOptions.setReasoningEffort(ReasoningEffortValue.fromString((String)fromSpringAiOptions.getReasoningEffort()));
        }
        return mergedAzureOptions;
    }

    private ChatCompletionsOptions copy(ChatCompletionsOptions fromOptions) {
        ChatCompletionsOptions copyOptions = new ChatCompletionsOptions(fromOptions.getMessages());
        if (fromOptions.isStream() != null) {
            ChatCompletionsOptionsAccessHelper.setStream((ChatCompletionsOptions)copyOptions, (boolean)fromOptions.isStream());
        }
        if (fromOptions.getStreamOptions() != null) {
            ChatCompletionsOptionsAccessHelper.setStreamOptions((ChatCompletionsOptions)copyOptions, (ChatCompletionStreamOptions)fromOptions.getStreamOptions());
        }
        if (fromOptions.getMaxTokens() != null) {
            copyOptions.setMaxTokens(fromOptions.getMaxTokens());
        }
        if (fromOptions.getLogitBias() != null) {
            copyOptions.setLogitBias(fromOptions.getLogitBias());
        }
        if (fromOptions.getStop() != null) {
            copyOptions.setStop(fromOptions.getStop());
        }
        if (fromOptions.getTemperature() != null) {
            copyOptions.setTemperature(fromOptions.getTemperature());
        }
        if (fromOptions.getTopP() != null) {
            copyOptions.setTopP(fromOptions.getTopP());
        }
        if (fromOptions.getFrequencyPenalty() != null) {
            copyOptions.setFrequencyPenalty(fromOptions.getFrequencyPenalty());
        }
        if (fromOptions.getPresencePenalty() != null) {
            copyOptions.setPresencePenalty(fromOptions.getPresencePenalty());
        }
        if (fromOptions.getN() != null) {
            copyOptions.setN(fromOptions.getN());
        }
        if (fromOptions.getUser() != null) {
            copyOptions.setUser(fromOptions.getUser());
        }
        if (fromOptions.getModel() != null) {
            copyOptions.setModel(fromOptions.getModel());
        }
        if (fromOptions.getResponseFormat() != null) {
            copyOptions.setResponseFormat(fromOptions.getResponseFormat());
        }
        if (fromOptions.getSeed() != null) {
            copyOptions.setSeed(fromOptions.getSeed());
        }
        copyOptions.setLogprobs(fromOptions.isLogprobs());
        if (fromOptions.getTopLogprobs() != null) {
            copyOptions.setTopLogprobs(fromOptions.getTopLogprobs());
        }
        if (fromOptions.getEnhancements() != null) {
            copyOptions.setEnhancements(fromOptions.getEnhancements());
        }
        if (fromOptions.getReasoningEffort() != null) {
            copyOptions.setReasoningEffort(fromOptions.getReasoningEffort());
        }
        return copyOptions;
    }

    private ChatCompletionsResponseFormat toAzureResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        if (responseFormat.getType() == AzureOpenAiResponseFormat.Type.JSON_OBJECT) {
            return new ChatCompletionsJsonResponseFormat();
        }
        if (responseFormat.getType() == AzureOpenAiResponseFormat.Type.JSON_SCHEMA) {
            AzureOpenAiResponseFormat.JsonSchema jsonSchema = responseFormat.getJsonSchema();
            ChatCompletionsJsonSchemaResponseFormatJsonSchema responseFormatJsonSchema = new ChatCompletionsJsonSchemaResponseFormatJsonSchema(jsonSchema.getName());
            String jsonString = ModelOptionsUtils.toJsonString(jsonSchema.getSchema());
            responseFormatJsonSchema.setSchema(BinaryData.fromString((String)jsonString));
            return new ChatCompletionsJsonSchemaResponseFormat(responseFormatJsonSchema);
        }
        return new ChatCompletionsTextResponseFormat();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OpenAIClientBuilder openAIClientBuilder;
        private AzureOpenAiChatOptions defaultOptions = AzureOpenAiChatOptions.builder().deploymentName("gpt-4o").temperature(DEFAULT_TEMPERATURE).build();
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder openAIClientBuilder(OpenAIClientBuilder openAIClientBuilder) {
            this.openAIClientBuilder = openAIClientBuilder;
            return this;
        }

        public Builder defaultOptions(AzureOpenAiChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public AzureOpenAiChatModel build() {
            if (this.toolCallingManager != null) {
                return new AzureOpenAiChatModel(this.openAIClientBuilder, this.defaultOptions, this.toolCallingManager, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new AzureOpenAiChatModel(this.openAIClientBuilder, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }
}

