/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.vertexai.autoconfigure.embedding;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.vertexai.autoconfigure.embedding.VertexAiEmbeddingConnectionAutoConfiguration;
import org.springframework.ai.model.vertexai.autoconfigure.embedding.VertexAiTextEmbeddingProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.ai.vertexai.embedding.VertexAiEmbeddingConnectionDetails;
import org.springframework.ai.vertexai.embedding.text.VertexAiTextEmbeddingModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class, VertexAiEmbeddingConnectionAutoConfiguration.class})
@ConditionalOnClass(value={VertexAiTextEmbeddingModel.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding.text"}, havingValue="vertexai", matchIfMissing=true)
@EnableConfigurationProperties(value={VertexAiTextEmbeddingProperties.class})
public class VertexAiTextEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAiTextEmbeddingModel textEmbedding(VertexAiEmbeddingConnectionDetails connectionDetails, VertexAiTextEmbeddingProperties textEmbeddingProperties, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        VertexAiTextEmbeddingModel embeddingModel = new VertexAiTextEmbeddingModel(connectionDetails, textEmbeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((VertexAiTextEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }
}

