/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.google.genai.autoconfigure.chat;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.genai.Client;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.google.genai.GoogleGenAiChatModel;
import org.springframework.ai.google.genai.cache.GoogleGenAiCachedContentService;
import org.springframework.ai.model.google.genai.autoconfigure.chat.CachedContentServiceCondition;
import org.springframework.ai.model.google.genai.autoconfigure.chat.GoogleGenAiChatProperties;
import org.springframework.ai.model.google.genai.autoconfigure.chat.GoogleGenAiConnectionProperties;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@ConditionalOnClass(value={Client.class, GoogleGenAiChatModel.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="google-genai", matchIfMissing=true)
@EnableConfigurationProperties(value={GoogleGenAiChatProperties.class, GoogleGenAiConnectionProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, ToolCallingAutoConfiguration.class})
public class GoogleGenAiChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Client googleGenAiClient(GoogleGenAiConnectionProperties connectionProperties) throws IOException {
        Client.Builder clientBuilder = Client.builder();
        if (StringUtils.hasText((String)connectionProperties.getApiKey())) {
            clientBuilder.apiKey(connectionProperties.getApiKey());
        } else {
            Assert.hasText((String)connectionProperties.getProjectId(), (String)"Google GenAI project-id must be set!");
            Assert.hasText((String)connectionProperties.getLocation(), (String)"Google GenAI location must be set!");
            clientBuilder.project(connectionProperties.getProjectId()).location(connectionProperties.getLocation()).vertexAI(true);
            if (connectionProperties.getCredentialsUri() != null) {
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)connectionProperties.getCredentialsUri().getInputStream());
            }
        }
        return clientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GoogleGenAiChatModel googleGenAiChatModel(Client googleGenAiClient, GoogleGenAiChatProperties chatProperties, ToolCallingManager toolCallingManager, ApplicationContext context, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<ToolExecutionEligibilityPredicate> toolExecutionEligibilityPredicate) {
        GoogleGenAiChatModel chatModel = GoogleGenAiChatModel.builder().genAiClient(googleGenAiClient).defaultOptions(chatProperties.getOptions()).toolCallingManager(toolCallingManager).toolExecutionEligibilityPredicate((ToolExecutionEligibilityPredicate)toolExecutionEligibilityPredicate.getIfUnique(() -> new DefaultToolExecutionEligibilityPredicate())).retryTemplate(retryTemplate).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).build();
        observationConvention.ifAvailable(arg_0 -> ((GoogleGenAiChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnBean(value={GoogleGenAiChatModel.class})
    @ConditionalOnMissingBean
    @Conditional(value={CachedContentServiceCondition.class})
    @ConditionalOnProperty(prefix="spring.ai.google.genai.chat", name={"enable-cached-content"}, havingValue="true", matchIfMissing=true)
    public GoogleGenAiCachedContentService googleGenAiCachedContentService(GoogleGenAiChatModel chatModel) {
        return chatModel.getCachedContentService();
    }
}

