/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.transport.WebMvcSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStdioDisabledCondition;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerSseProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.ServerResponse;

@AutoConfiguration(before={McpServerAutoConfiguration.class})
@EnableConfigurationProperties(value={McpServerSseProperties.class})
@ConditionalOnClass(value={WebMvcSseServerTransportProvider.class})
@ConditionalOnMissingBean(value={McpServerTransportProvider.class})
@Conditional(value={McpServerStdioDisabledCondition.class, McpServerAutoConfiguration.EnabledSseServerCondition.class})
public class McpServerSseWebMvcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebMvcSseServerTransportProvider webMvcSseServerTransportProvider(@Qualifier(value="mcpServerObjectMapper") ObjectMapper objectMapper, McpServerSseProperties serverProperties) {
        return WebMvcSseServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(objectMapper)).baseUrl(serverProperties.getBaseUrl()).sseEndpoint(serverProperties.getSseEndpoint()).messageEndpoint(serverProperties.getSseMessageEndpoint()).keepAliveInterval(serverProperties.getKeepAliveInterval()).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"webMvcSseServerRouterFunction"})
    public RouterFunction<ServerResponse> webMvcSseServerRouterFunction(WebMvcSseServerTransportProvider transportProvider) {
        return transportProvider.getRouterFunction();
    }
}

