/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.annotations;

import io.modelcontextprotocol.server.McpServerFeatures;
import java.util.List;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.annotation.spring.AsyncMcpAnnotationProviders;
import org.springframework.ai.mcp.annotation.spring.SyncMcpAnnotationProviders;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.annotations.McpServerAnnotationScannerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={McpServerAnnotationScannerAutoConfiguration.class})
@ConditionalOnClass(value={McpTool.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Conditional(value={McpServerAutoConfiguration.NonStatelessServerCondition.class})
public class McpServerSpecificationFactoryAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    static class AsyncServerSpecificationConfiguration {
        AsyncServerSpecificationConfiguration() {
        }

        @Bean
        public List<McpServerFeatures.AsyncResourceSpecification> resourceSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.resourceSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpResource.class));
        }

        @Bean
        public List<McpServerFeatures.AsyncPromptSpecification> promptSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.promptSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpPrompt.class));
        }

        @Bean
        public List<McpServerFeatures.AsyncCompletionSpecification> completionSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.completeSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpComplete.class));
        }

        @Bean
        public List<McpServerFeatures.AsyncToolSpecification> toolSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.toolSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpTool.class));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    static class SyncServerSpecificationConfiguration {
        SyncServerSpecificationConfiguration() {
        }

        @Bean
        public List<McpServerFeatures.SyncResourceSpecification> resourceSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.resourceSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpResource.class));
        }

        @Bean
        public List<McpServerFeatures.SyncPromptSpecification> promptSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.promptSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpPrompt.class));
        }

        @Bean
        public List<McpServerFeatures.SyncCompletionSpecification> completionSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.completeSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpComplete.class));
        }

        @Bean
        public List<McpServerFeatures.SyncToolSpecification> toolSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.toolSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpTool.class));
        }
    }
}

