/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.mcp.annotation.spring.ClientMcpAsyncHandlersRegistry;
import org.springframework.ai.mcp.annotation.spring.ClientMcpSyncHandlersRegistry;
import org.springframework.ai.mcp.client.common.autoconfigure.McpAsyncToolsChangeEventEmmiter;
import org.springframework.ai.mcp.client.common.autoconfigure.McpSyncToolsChangeEventEmmiter;
import org.springframework.ai.mcp.client.common.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.common.autoconfigure.configurer.McpAsyncClientConfigurer;
import org.springframework.ai.mcp.client.common.autoconfigure.configurer.McpSyncClientConfigurer;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.ai.mcp.customizer.McpAsyncClientCustomizer;
import org.springframework.ai.mcp.customizer.McpSyncClientCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(afterName={"org.springframework.ai.mcp.client.common.autoconfigure.StdioTransportAutoConfiguration", "org.springframework.ai.mcp.client.httpclient.autoconfigure.SseHttpClientTransportAutoConfiguration", "org.springframework.ai.mcp.client.httpclient.autoconfigure.StreamableHttpHttpClientTransportAutoConfiguration", "org.springframework.ai.mcp.client.webflux.autoconfigure.SseWebFluxTransportAutoConfiguration", "org.springframework.ai.mcp.client.webflux.autoconfigure.StreamableHttpWebFluxTransportAutoConfiguration"})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpClientAutoConfiguration {
    private String connectedClientName(String clientName, String serverConnectionName) {
        return clientName + " - " + serverConnectionName;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public McpSyncToolsChangeEventEmmiter mcpSyncToolChangeEventEmmiter(ApplicationEventPublisher applicationEventPublisher) {
        return new McpSyncToolsChangeEventEmmiter(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpSyncClient> mcpSyncClients(McpSyncClientConfigurer mcpSyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider, ClientMcpSyncHandlersRegistry clientMcpSyncHandlersRegistry) {
        ArrayList<McpSyncClient> mcpSyncClients = new ArrayList<McpSyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(this.connectedClientName(commonProperties.getName(), namedTransport.name()), namedTransport.name(), commonProperties.getVersion());
                McpClient.SyncSpec spec = McpClient.sync((McpClientTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout()).sampling(samplingRequest -> clientMcpSyncHandlersRegistry.handleSampling(namedTransport.name(), samplingRequest)).elicitation(elicitationRequest -> clientMcpSyncHandlersRegistry.handleElicitation(namedTransport.name(), elicitationRequest)).loggingConsumer(loggingMessageNotification -> clientMcpSyncHandlersRegistry.handleLogging(namedTransport.name(), loggingMessageNotification)).progressConsumer(progressNotification -> clientMcpSyncHandlersRegistry.handleProgress(namedTransport.name(), progressNotification)).toolsChangeConsumer(newTools -> clientMcpSyncHandlersRegistry.handleToolListChanged(namedTransport.name(), newTools)).promptsChangeConsumer(newPrompts -> clientMcpSyncHandlersRegistry.handlePromptListChanged(namedTransport.name(), newPrompts)).resourcesChangeConsumer(newResources -> clientMcpSyncHandlersRegistry.handleResourceListChanged(namedTransport.name(), newResources)).capabilities(clientMcpSyncHandlersRegistry.getCapabilities(namedTransport.name()));
                spec = mcpSyncClientConfigurer.configure(namedTransport.name(), spec);
                McpSyncClient client = spec.build();
                if (commonProperties.isInitialized()) {
                    client.initialize();
                }
                mcpSyncClients.add(client);
            }
        }
        return mcpSyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public CloseableMcpSyncClients makeSyncClientsClosable(List<McpSyncClient> clients) {
        return new CloseableMcpSyncClients(clients);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    McpSyncClientConfigurer mcpSyncClientConfigurer(ObjectProvider<McpSyncClientCustomizer> customizerProvider) {
        return new McpSyncClientConfigurer(customizerProvider.orderedStream().toList());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public McpAsyncToolsChangeEventEmmiter mcpAsyncToolChangeEventEmmiter(ApplicationEventPublisher applicationEventPublisher) {
        return new McpAsyncToolsChangeEventEmmiter(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public List<McpAsyncClient> mcpAsyncClients(McpAsyncClientConfigurer mcpAsyncClientConfigurer, McpClientCommonProperties commonProperties, ObjectProvider<List<NamedClientMcpTransport>> transportsProvider, ClientMcpAsyncHandlersRegistry clientMcpAsyncHandlersRegistry) {
        ArrayList<McpAsyncClient> mcpAsyncClients = new ArrayList<McpAsyncClient>();
        List namedTransports = transportsProvider.stream().flatMap(Collection::stream).toList();
        if (!CollectionUtils.isEmpty(namedTransports)) {
            for (NamedClientMcpTransport namedTransport : namedTransports) {
                McpSchema.Implementation clientInfo = new McpSchema.Implementation(this.connectedClientName(commonProperties.getName(), namedTransport.name()), commonProperties.getVersion());
                McpClient.AsyncSpec spec = McpClient.async((McpClientTransport)namedTransport.transport()).clientInfo(clientInfo).requestTimeout(commonProperties.getRequestTimeout()).sampling(samplingRequest -> clientMcpAsyncHandlersRegistry.handleSampling(namedTransport.name(), samplingRequest)).elicitation(elicitationRequest -> clientMcpAsyncHandlersRegistry.handleElicitation(namedTransport.name(), elicitationRequest)).loggingConsumer(loggingMessageNotification -> clientMcpAsyncHandlersRegistry.handleLogging(namedTransport.name(), loggingMessageNotification)).progressConsumer(progressNotification -> clientMcpAsyncHandlersRegistry.handleProgress(namedTransport.name(), progressNotification)).toolsChangeConsumer(newTools -> clientMcpAsyncHandlersRegistry.handleToolListChanged(namedTransport.name(), newTools)).promptsChangeConsumer(newPrompts -> clientMcpAsyncHandlersRegistry.handlePromptListChanged(namedTransport.name(), newPrompts)).resourcesChangeConsumer(newResources -> clientMcpAsyncHandlersRegistry.handleResourceListChanged(namedTransport.name(), newResources)).capabilities(clientMcpAsyncHandlersRegistry.getCapabilities(namedTransport.name()));
                spec = mcpAsyncClientConfigurer.configure(namedTransport.name(), spec);
                McpAsyncClient client = spec.build();
                if (commonProperties.isInitialized()) {
                    client.initialize().block();
                }
                mcpAsyncClients.add(client);
            }
        }
        return mcpAsyncClients;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public CloseableMcpAsyncClients makeAsyncClientsClosable(List<McpAsyncClient> clients) {
        return new CloseableMcpAsyncClients(clients);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    McpAsyncClientConfigurer mcpAsyncClientConfigurer(ObjectProvider<McpAsyncClientCustomizer> customizerProvider) {
        return new McpAsyncClientConfigurer(customizerProvider.orderedStream().toList());
    }

    public record CloseableMcpSyncClients(List<McpSyncClient> clients) implements AutoCloseable
    {
        @Override
        public void close() {
            this.clients.forEach(McpSyncClient::close);
        }
    }

    public record CloseableMcpAsyncClients(List<McpAsyncClient> clients) implements AutoCloseable
    {
        @Override
        public void close() {
            this.clients.forEach(McpAsyncClient::close);
        }
    }
}

