/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpSyncClient;
import java.util.Collection;
import java.util.List;
import org.springframework.ai.mcp.AsyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.DefaultMcpToolNamePrefixGenerator;
import org.springframework.ai.mcp.McpToolFilter;
import org.springframework.ai.mcp.McpToolNamePrefixGenerator;
import org.springframework.ai.mcp.SyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.ToolContextToMcpMetaConverter;
import org.springframework.ai.mcp.client.common.autoconfigure.McpClientAutoConfiguration;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@AutoConfiguration(after={McpClientAutoConfiguration.class})
@EnableConfigurationProperties(value={McpClientCommonProperties.class})
@Conditional(value={McpToolCallbackAutoConfigurationCondition.class})
public class McpToolCallbackAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public McpToolNamePrefixGenerator defaultMcpToolNamePrefixGenerator() {
        return new DefaultMcpToolNamePrefixGenerator();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public SyncMcpToolCallbackProvider mcpToolCallbacks(ObjectProvider<McpToolFilter> syncClientsToolFilter, ObjectProvider<List<McpSyncClient>> syncMcpClients, ObjectProvider<McpToolNamePrefixGenerator> mcpToolNamePrefixGenerator, ObjectProvider<ToolContextToMcpMetaConverter> toolContextToMcpMetaConverter) {
        List mcpClients = syncMcpClients.stream().flatMap(Collection::stream).toList();
        return SyncMcpToolCallbackProvider.builder().mcpClients(mcpClients).toolFilter((McpToolFilter)syncClientsToolFilter.getIfUnique(() -> (McpSyncClient2, tool) -> true)).toolNamePrefixGenerator((McpToolNamePrefixGenerator)mcpToolNamePrefixGenerator.getIfUnique(() -> McpToolNamePrefixGenerator.noPrefix())).toolContextToMcpMetaConverter((ToolContextToMcpMetaConverter)toolContextToMcpMetaConverter.getIfUnique(() -> ToolContextToMcpMetaConverter.defaultConverter())).build();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"type"}, havingValue="ASYNC")
    public AsyncMcpToolCallbackProvider mcpAsyncToolCallbacks(ObjectProvider<McpToolFilter> asyncClientsToolFilter, ObjectProvider<List<McpAsyncClient>> mcpClientsProvider, ObjectProvider<McpToolNamePrefixGenerator> toolNamePrefixGenerator, ObjectProvider<ToolContextToMcpMetaConverter> toolContextToMcpMetaConverter) {
        List mcpClients = mcpClientsProvider.stream().flatMap(Collection::stream).toList();
        return AsyncMcpToolCallbackProvider.builder().toolFilter((McpToolFilter)asyncClientsToolFilter.getIfUnique(() -> (McpAsyncClient2, tool) -> true)).toolNamePrefixGenerator((McpToolNamePrefixGenerator)toolNamePrefixGenerator.getIfUnique(() -> McpToolNamePrefixGenerator.noPrefix())).toolContextToMcpMetaConverter((ToolContextToMcpMetaConverter)toolContextToMcpMetaConverter.getIfUnique(() -> ToolContextToMcpMetaConverter.defaultConverter())).mcpClients(mcpClients).build();
    }

    public static class McpToolCallbackAutoConfigurationCondition
    extends AllNestedConditions {
        public McpToolCallbackAutoConfigurationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.client.toolcallback", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class ToolCallbackProviderEnabled {
            ToolCallbackProviderEnabled() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class McpAutoConfigEnabled {
            McpAutoConfigEnabled() {
            }
        }
    }
}

