/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.metadata;

import java.time.Duration;
import org.springframework.ai.chat.metadata.RateLimit;

public class AnthropicRateLimit
implements RateLimit {
    private static final String RATE_LIMIT_STRING = "{ @type: %1$s, requestsLimit: %2$s, requestsRemaining: %3$s, requestsReset: %4$s, tokensLimit: %5$s; tokensRemaining: %6$s; tokensReset: %7$s }";
    private final Long requestsLimit;
    private final Long requestsRemaining;
    private final Long tokensLimit;
    private final Long tokensRemaining;
    private final Duration requestsReset;
    private final Duration tokensReset;

    public AnthropicRateLimit(Long requestsLimit, Long requestsRemaining, Duration requestsReset, Long tokensLimit, Long tokensRemaining, Duration tokensReset) {
        this.requestsLimit = requestsLimit;
        this.requestsRemaining = requestsRemaining;
        this.requestsReset = requestsReset;
        this.tokensLimit = tokensLimit;
        this.tokensRemaining = tokensRemaining;
        this.tokensReset = tokensReset;
    }

    public Long getRequestsLimit() {
        return this.requestsLimit;
    }

    public Long getTokensLimit() {
        return this.tokensLimit;
    }

    public Long getRequestsRemaining() {
        return this.requestsRemaining;
    }

    public Long getTokensRemaining() {
        return this.tokensRemaining;
    }

    public Duration getRequestsReset() {
        return this.requestsReset;
    }

    public Duration getTokensReset() {
        return this.tokensReset;
    }

    public String toString() {
        return RATE_LIMIT_STRING.formatted(this.getClass().getName(), this.getRequestsLimit(), this.getRequestsRemaining(), this.getRequestsReset(), this.getTokensLimit(), this.getTokensRemaining(), this.getTokensReset());
    }
}

