/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springdoc.core.extractor.DelegatingMethodParameter;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.models.ParameterId;
import org.springdoc.core.models.ParameterInfo;
import org.springdoc.core.models.RequestBodyInfo;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequestService {
    private static final List<Class<?>> PARAM_TYPES_TO_IGNORE = Collections.synchronizedList(new ArrayList());
    private static final String[] ANNOTATIONS_FOR_REQUIRED = new String[]{"NotNull", "NonNull", "NotBlank", "NotEmpty"};
    private static final String POSITIVE_OR_ZERO = "PositiveOrZero";
    private static final String NEGATIVE_OR_ZERO = "NegativeOrZero";
    private final GenericParameterService parameterBuilder;
    private final RequestBodyService requestBodyService;
    private final SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer;
    private final Optional<List<ParameterCustomizer>> parameterCustomizers;
    private final boolean defaultFlatParamObject;
    private boolean defaultSupportFormData;

    protected AbstractRequestService(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, Optional<List<ParameterCustomizer>> parameterCustomizers, SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyService = requestBodyService;
        parameterCustomizers.ifPresent(customizers -> customizers.removeIf(Objects::isNull));
        this.parameterCustomizers = parameterCustomizers;
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
        this.defaultFlatParamObject = parameterBuilder.getPropertyResolverUtils().getSpringDocConfigProperties().isDefaultFlatParamObject();
        this.defaultSupportFormData = parameterBuilder.getPropertyResolverUtils().getSpringDocConfigProperties().isDefaultSupportFormData();
    }

    public static void addRequestWrapperToIgnore(Class<?> ... classes) {
        PARAM_TYPES_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeRequestWrapperToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (PARAM_TYPES_TO_IGNORE.containsAll(classesToIgnore)) {
            PARAM_TYPES_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    public static boolean isRequestTypeToIgnore(Class<?> rawClass) {
        return PARAM_TYPES_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public static Collection<io.swagger.v3.oas.models.parameters.Parameter> getHeaders(MethodAttributes methodAttributes, Map<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> map) {
        for (Map.Entry<String, String> entry : methodAttributes.getHeaders().entrySet()) {
            io.swagger.v3.oas.models.parameters.Parameter parameter;
            ParameterId parameterId;
            StringSchema schema = new StringSchema();
            if (StringUtils.isNotEmpty((CharSequence)entry.getValue())) {
                schema.addEnumItem(entry.getValue());
            }
            if (map.containsKey(parameterId = new ParameterId(parameter = new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.HEADER.toString()).name(entry.getKey()).schema((Schema)schema)))) {
                parameter = map.get(parameterId);
                List existingEnum = null;
                if (parameter.getSchema() != null && !CollectionUtils.isEmpty((Collection)parameter.getSchema().getEnum())) {
                    existingEnum = parameter.getSchema().getEnum();
                }
                if (StringUtils.isNotEmpty((CharSequence)entry.getValue()) && (existingEnum == null || !existingEnum.contains(entry.getValue()))) {
                    parameter.getSchema().addEnumItemObject((Object)entry.getValue());
                }
                parameter.setSchema(parameter.getSchema());
            }
            map.put(parameterId, parameter);
        }
        return map.values();
    }

    public Operation build(HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MethodAttributes methodAttributes, OpenAPI openAPI) {
        io.swagger.v3.oas.models.parameters.Parameter parameter;
        String operationId = operation.getOperationId() != null ? operation.getOperationId() : handlerMethod.getMethod().getName();
        operation.setOperationId(operationId);
        String[] pNames = this.localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(Parameter::getName).toArray(String[]::new);
        if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
            pNames = reflectionParametersNames;
        }
        parameters = DelegatingMethodParameter.customize(pNames, parameters, this.parameterBuilder.getOptionalDelegatingMethodParameterCustomizers(), this.defaultFlatParamObject);
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
        List operationParameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
        Map<ParameterId, io.swagger.v3.oas.annotations.Parameter> parametersDocMap = this.getApiParameters(handlerMethod.getMethod());
        Components components = openAPI.getComponents();
        JavadocProvider javadocProvider = this.parameterBuilder.getJavadocProvider();
        for (MethodParameter methodParameter : parameters) {
            io.swagger.v3.oas.annotations.media.Schema schema;
            parameter = null;
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), io.swagger.v3.oas.annotations.Parameter.class);
            String pName = methodParameter.getParameterName();
            ParameterInfo parameterInfo = new ParameterInfo(pName, methodParameter, this.parameterBuilder, parameterDoc);
            if (parameterDoc == null) {
                parameterDoc = parametersDocMap.get(parameterInfo.getParameterId());
            }
            if (parameterDoc == null && (schema = (io.swagger.v3.oas.annotations.media.Schema)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)AnnotatedElementUtils.forAnnotations((Annotation[])methodParameter.getParameterAnnotations()), io.swagger.v3.oas.annotations.media.Schema.class)) != null) {
                parameterDoc = this.parameterBuilder.generateParameterBySchema(schema);
            }
            if (parameterDoc != null) {
                if (parameterDoc.hidden() || parameterDoc.schema().hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
                parameterInfo.setParameterModel(parameter);
            }
            if (this.isParamToIgnore(methodParameter)) continue;
            parameter = this.buildParams(parameterInfo, components, requestMethod, methodAttributes, openAPI.getOpenapi());
            List<Annotation> parameterAnnotations = List.of(SpringDocUtils.getParameterAnnotations(methodParameter));
            if (this.isValidParameter(parameter, methodAttributes)) {
                String paramJavadocDescription;
                if (StringUtils.isBlank((CharSequence)(parameter = GenericParameterService.mergeParameter(operationParameters, parameter)).getDescription()) && javadocProvider != null && !StringUtils.isBlank((CharSequence)(paramJavadocDescription = this.parameterBuilder.getParamJavadoc(javadocProvider, methodParameter)))) {
                    parameter.setDescription(paramJavadocDescription);
                }
                this.applyBeanValidatorAnnotations(parameter, parameterAnnotations, parameterInfo.isParameterObject());
            } else if (!RequestMethod.GET.equals((Object)requestMethod) || SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openAPI.getOpenapi())) {
                if (operation.getRequestBody() != null) {
                    requestBodyInfo.setRequestBody(operation.getRequestBody());
                }
                this.requestBodyService.calculateRequestBodyInfo(components, methodAttributes, parameterInfo, requestBodyInfo);
                this.applyBeanValidatorAnnotations(requestBodyInfo.getRequestBody(), parameterAnnotations, methodParameter.isOptional());
            }
            this.customiseParameter(parameter, parameterInfo, operationParameters);
        }
        LinkedHashMap<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> map = this.getParameterLinkedHashMap(components, methodAttributes, operationParameters, parametersDocMap);
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        if (this.defaultSupportFormData && requestBody != null && requestBody.getContent() != null && requestBody.getContent().containsKey((Object)"multipart/form-data")) {
            Iterator<Map.Entry<ParameterId, io.swagger.v3.oas.models.parameters.Parameter>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> entry = it.next();
                parameter = entry.getValue();
                if (ParameterIn.PATH.toString().equals(parameter.getIn()) || ParameterIn.HEADER.toString().equals(parameter.getIn()) || ParameterIn.COOKIE.toString().equals(parameter.getIn())) continue;
                Schema itemSchema = new Schema();
                itemSchema.setName(entry.getKey().getpName());
                itemSchema.setDescription(parameter.getDescription());
                itemSchema.setDeprecated(parameter.getDeprecated());
                if (parameter.getExample() != null) {
                    itemSchema.setExample(parameter.getExample());
                }
                requestBodyInfo.addProperties(entry.getKey().getpName(), itemSchema);
                it.remove();
            }
        }
        this.setParams(operation, new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(map.values()), requestBodyInfo);
        return operation;
    }

    private LinkedHashMap<ParameterId, io.swagger.v3.oas.models.parameters.Parameter> getParameterLinkedHashMap(Components components, MethodAttributes methodAttributes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Map<ParameterId, io.swagger.v3.oas.annotations.Parameter> parametersDocMap) {
        LinkedHashMap map = operationParameters.stream().collect(Collectors.toMap(ParameterId::new, parameter -> parameter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        for (Map.Entry<ParameterId, io.swagger.v3.oas.annotations.Parameter> entry : parametersDocMap.entrySet()) {
            ParameterId parameterId2 = entry.getKey();
            if (parameterId2 == null || map.containsKey(parameterId2) || entry.getValue().hidden()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = this.parameterBuilder.buildParameterFromDoc(entry.getValue(), components, methodAttributes.getJsonViewAnnotation(), methodAttributes.getLocale());
            if (map.containsKey(parameterId2)) {
                GenericParameterService.mergeParameter((io.swagger.v3.oas.models.parameters.Parameter)map.get(parameterId2), parameter2);
                map.put(parameterId2, parameter2);
                continue;
            }
            long mumParamsWithName = map.keySet().stream().filter(parameterId1 -> parameterId2.getpName().equals(parameterId1.getpName())).count();
            long mumParamsDocWithName = parametersDocMap.keySet().stream().filter(parameterId1 -> parameterId2.getpName().equals(parameterId1.getpName())).count();
            if (mumParamsWithName == 1L && mumParamsDocWithName == 1L) {
                Optional<ParameterId> parameterIdWithSameNameOptional = map.keySet().stream().filter(parameterId1 -> parameterId2.getpName().equals(parameterId1.getpName())).findAny();
                parameterIdWithSameNameOptional.ifPresent(parameterIdWithSameName -> {
                    GenericParameterService.mergeParameter((io.swagger.v3.oas.models.parameters.Parameter)map.get(parameterIdWithSameName), parameter2);
                    map.put(parameterIdWithSameName, parameter2);
                });
                continue;
            }
            map.put(parameterId2, parameter2);
        }
        AbstractRequestService.getHeaders(methodAttributes, map);
        map.forEach((parameterId, parameter) -> {
            if (StringUtils.isBlank((CharSequence)parameter.getIn()) && StringUtils.isBlank((CharSequence)parameter.get$ref())) {
                parameter.setIn(ParameterIn.QUERY.toString());
            }
        });
        return map;
    }

    protected void customiseParameter(io.swagger.v3.oas.models.parameters.Parameter parameter, ParameterInfo parameterInfo, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters) {
        if (this.parameterCustomizers.isPresent()) {
            List<ParameterCustomizer> parameterCustomizerList = this.parameterCustomizers.get();
            int index = operationParameters.indexOf(parameter);
            for (ParameterCustomizer parameterCustomizer : parameterCustomizerList) {
                parameter = parameterCustomizer.customize(parameter, parameterInfo.getMethodParameter());
            }
            if (index != -1) {
                if (parameter == null) {
                    operationParameters.remove(index);
                } else {
                    operationParameters.set(index, parameter);
                }
            }
        }
    }

    public boolean isParamToIgnore(MethodParameter parameter) {
        if (SpringDocAnnotationsUtils.isAnnotationToIgnore(parameter)) {
            return true;
        }
        if (this.isRequiredAnnotation(parameter)) {
            return false;
        }
        if (this.isRequestBodyWithMapType(parameter)) {
            return false;
        }
        return AbstractRequestService.isRequestTypeToIgnore(parameter.getParameterType());
    }

    private boolean isRequiredAnnotation(MethodParameter parameter) {
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        PathVariable pathVariable = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        org.springframework.web.bind.annotation.RequestBody requestBody = (org.springframework.web.bind.annotation.RequestBody)parameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class);
        return requestParam != null && requestParam.required() || pathVariable != null && pathVariable.required() || requestBody != null && requestBody.required();
    }

    private boolean isRequestBodyWithMapType(MethodParameter parameter) {
        if (parameter.getContainingClass().getPackageName().startsWith("org.springframework.boot.actuate")) {
            return false;
        }
        org.springframework.web.bind.annotation.RequestBody requestBody = (org.springframework.web.bind.annotation.RequestBody)parameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class);
        if (requestBody == null) {
            return false;
        }
        Class parameterType = parameter.getParameterType();
        return Map.class.isAssignableFrom(parameterType);
    }

    private void setParams(Operation operation, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, RequestBodyInfo requestBodyInfo) {
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
    }

    public boolean isValidParameter(io.swagger.v3.oas.models.parameters.Parameter parameter, MethodAttributes methodAttributes) {
        return !(parameter == null || parameter.getName() == null && parameter.get$ref() == null || Arrays.asList(methodAttributes.getMethodConsumes()).contains("application/x-www-form-urlencoded") && ParameterIn.QUERY.toString().equals(parameter.getIn()));
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParams(ParameterInfo parameterInfo, Components components, RequestMethod requestMethod, MethodAttributes methodAttributes, String openApiVersion) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        if (parameterInfo.getParamType() != null) {
            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(parameterInfo.getDefaultValue())) {
                parameterInfo.setRequired(false);
            } else {
                parameterInfo.setDefaultValue(null);
            }
            return this.buildParam(parameterInfo, components, methodAttributes.getJsonViewAnnotation());
        }
        if (!this.isRequestBodyParam(requestMethod, parameterInfo, openApiVersion, methodAttributes)) {
            parameterInfo.setRequired(!((DelegatingMethodParameter)methodParameter).isNotRequired() && !methodParameter.isOptional());
            parameterInfo.setDefaultValue(null);
            return this.buildParam(parameterInfo, components, methodAttributes.getJsonViewAnnotation());
        }
        return null;
    }

    public io.swagger.v3.oas.models.parameters.Parameter buildParam(ParameterInfo parameterInfo, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = parameterInfo.getParameterModel();
        String name = parameterInfo.getpName();
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameterInfo.setParameterModel(parameter);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn(parameterInfo.getParamType());
        }
        if (parameter.getRequired() == null) {
            parameter.setRequired(Boolean.valueOf(parameterInfo.isRequired()));
        }
        if (SchemaPropertyDeprecatingConverter.containsDeprecatedAnnotation(parameterInfo.getMethodParameter().getParameterAnnotations())) {
            parameter.setDeprecated(Boolean.valueOf(true));
        }
        if (parameter.getSchema() == null && parameter.getContent() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo, null, jsonView);
            if (parameterInfo.getDefaultValue() != null && schema != null) {
                Object defaultValue = parameterInfo.getDefaultValue();
                PrimitiveType primitiveType = PrimitiveType.fromTypeAndFormat((String)schema.getType(), (String)schema.getFormat());
                if (primitiveType != null) {
                    Schema primitiveSchema = primitiveType.createProperty();
                    primitiveSchema.setDefault(parameterInfo.getDefaultValue());
                    defaultValue = primitiveSchema.getDefault();
                }
                schema.setDefault(defaultValue);
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    public void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations, boolean isParameterObject) {
        boolean annotationExists;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), (Annotation)annotation));
        }
        if ((annotationExists = AbstractRequestService.hasNotNullAnnotation(annos.keySet())) && !isParameterObject) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        this.applyValidationsToSchema(annos, schema);
    }

    public void applyBeanValidatorAnnotations(RequestBody requestBody, List<Annotation> annotations, boolean isOptional) {
        boolean validationExists;
        HashMap annos = new HashMap();
        boolean springRequestBodyRequired = false;
        boolean swaggerRequestBodyRequired = false;
        if (!CollectionUtils.isEmpty(annotations)) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getSimpleName(), annotation));
            springRequestBodyRequired = annotations.stream().filter(annotation -> org.springframework.web.bind.annotation.RequestBody.class.equals(annotation.annotationType())).anyMatch(annotation -> ((org.springframework.web.bind.annotation.RequestBody)annotation).required());
            swaggerRequestBodyRequired = annotations.stream().filter(annotation -> io.swagger.v3.oas.annotations.parameters.RequestBody.class.equals(annotation.annotationType())).anyMatch(annotation -> ((io.swagger.v3.oas.annotations.parameters.RequestBody)annotation).required());
        }
        if ((validationExists = AbstractRequestService.hasNotNullAnnotation(annos.keySet())) || !isOptional && (springRequestBodyRequired || swaggerRequestBodyRequired)) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
    }

    public RequestBodyService getRequestBodyBuilder() {
        return this.requestBodyService;
    }

    public boolean isDefaultFlatParamObject() {
        return this.defaultFlatParamObject;
    }

    public GenericParameterService getParameterBuilder() {
        return this.parameterBuilder;
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getSimpleName())) {
            Size size = (Size)annos.get(Size.class.getSimpleName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    private Map<ParameterId, io.swagger.v3.oas.annotations.Parameter> getApiParameters(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiParametersDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameters.class);
        LinkedHashMap apiParametersMap = apiParametersDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(ParameterId::new, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        Set apiParametersDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameters.class);
        LinkedHashMap apiParametersDocDeclaringClassMap = apiParametersDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(ParameterId::new, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParametersDocDeclaringClassMap);
        Set apiParameterDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocMap = apiParameterDoc.stream().collect(Collectors.toMap(ParameterId::new, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocMap);
        Set apiParameterDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocDeclaringClassMap = apiParameterDocDeclaringClass.stream().collect(Collectors.toMap(ParameterId::new, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocDeclaringClassMap);
        return apiParametersMap;
    }

    private void applyValidationsToSchema(Map<String, Annotation> annos, Schema<?> schema) {
        Max max;
        Min min;
        if (annos.containsKey(Min.class.getSimpleName())) {
            min = (Min)annos.get(Min.class.getSimpleName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getSimpleName())) {
            max = (Max)annos.get(Max.class.getSimpleName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getSimpleName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getSimpleName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(DecimalMax.class.getSimpleName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getSimpleName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(true));
            }
        }
        if (annos.containsKey(POSITIVE_OR_ZERO)) {
            schema.setMinimum(BigDecimal.ZERO);
        }
        if (annos.containsKey(NEGATIVE_OR_ZERO)) {
            schema.setMaximum(BigDecimal.ZERO);
        }
        if (annos.containsKey(Pattern.class.getSimpleName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getSimpleName());
            schema.setPattern(pattern.regexp());
        }
    }

    private boolean isRequestBodyParam(RequestMethod requestMethod, ParameterInfo parameterInfo, String openApiVersion, MethodAttributes methodAttributes) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        DelegatingMethodParameter delegatingMethodParameter = (DelegatingMethodParameter)methodParameter;
        boolean isBodyAllowed = !RequestMethod.GET.equals((Object)requestMethod) || SpringDocConfigProperties.ApiDocs.OpenApiVersion.OPENAPI_3_1.getVersion().equals(openApiVersion);
        return !(!isBodyAllowed || parameterInfo.getParameterModel() != null && parameterInfo.getParameterModel().getIn() != null || delegatingMethodParameter.isParameterObject() || !this.checkRequestBodyAnnotation(methodParameter) && !this.checkOperationRequestBody(methodParameter) && !this.checkFile(methodParameter) && !Arrays.asList(methodAttributes.getMethodConsumes()).contains("multipart/form-data"));
    }

    private boolean checkRequestBodyAnnotation(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class) || methodParameter.hasParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)Objects.requireNonNull(methodParameter.getParameter()), io.swagger.v3.oas.annotations.parameters.RequestBody.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), io.swagger.v3.oas.annotations.parameters.RequestBody.class);
    }

    private boolean checkFile(MethodParameter methodParameter) {
        if (methodParameter.getParameterAnnotation(RequestPart.class) != null) {
            return true;
        }
        if (methodParameter.getParameterAnnotation(RequestParam.class) != null) {
            return GenericParameterService.isFile(methodParameter.getParameterType());
        }
        return false;
    }

    private boolean checkOperationRequestBody(MethodParameter methodParameter) {
        io.swagger.v3.oas.annotations.Operation operation;
        if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), io.swagger.v3.oas.annotations.Operation.class) != null && (operation = (io.swagger.v3.oas.annotations.Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)Objects.requireNonNull(methodParameter.getMethod()), io.swagger.v3.oas.annotations.Operation.class)) != null) {
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBody = operation.requestBody();
            if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
                return true;
            }
            if (requestBody.required()) {
                return true;
            }
            if (requestBody.useParameterTypeSchema()) {
                return true;
            }
            if (requestBody.content().length > 0) {
                return true;
            }
            return requestBody.extensions().length > 0;
        }
        return false;
    }

    public static boolean hasNotNullAnnotation(Collection<String> annotationSimpleNames) {
        return Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annotationSimpleNames::contains);
    }

    static {
        PARAM_TYPES_TO_IGNORE.add(WebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(NativeWebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(Principal.class);
        PARAM_TYPES_TO_IGNORE.add(HttpMethod.class);
        PARAM_TYPES_TO_IGNORE.add(Locale.class);
        PARAM_TYPES_TO_IGNORE.add(TimeZone.class);
        PARAM_TYPES_TO_IGNORE.add(InputStream.class);
        PARAM_TYPES_TO_IGNORE.add(ZoneId.class);
        PARAM_TYPES_TO_IGNORE.add(Reader.class);
        PARAM_TYPES_TO_IGNORE.add(OutputStream.class);
        PARAM_TYPES_TO_IGNORE.add(Writer.class);
        PARAM_TYPES_TO_IGNORE.add(Map.class);
        PARAM_TYPES_TO_IGNORE.add(Model.class);
        PARAM_TYPES_TO_IGNORE.add(ModelMap.class);
        PARAM_TYPES_TO_IGNORE.add(Errors.class);
        PARAM_TYPES_TO_IGNORE.add(BindingResult.class);
        PARAM_TYPES_TO_IGNORE.add(SessionStatus.class);
        PARAM_TYPES_TO_IGNORE.add(UriComponentsBuilder.class);
        PARAM_TYPES_TO_IGNORE.add(RequestAttribute.class);
    }
}

