/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.customisers;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.DelegatingMethodParameter;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.web.PageableDefault;

public class DataRestDelegatingMethodParameterCustomizer
implements DelegatingMethodParameterCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestDelegatingMethodParameterCustomizer.class);
    private final Optional<SpringDataWebProperties> optionalSpringDataWebProperties;
    private final Optional<RepositoryRestConfiguration> optionalRepositoryRestConfiguration;

    public DataRestDelegatingMethodParameterCustomizer(Optional<SpringDataWebProperties> optionalSpringDataWebProperties, Optional<RepositoryRestConfiguration> optionalRepositoryRestConfiguration) {
        this.optionalSpringDataWebProperties = optionalSpringDataWebProperties;
        this.optionalRepositoryRestConfiguration = optionalRepositoryRestConfiguration;
    }

    public void customize(MethodParameter originalParameter, MethodParameter methodParameter) {
        PageableDefault pageableDefault = (PageableDefault)originalParameter.getParameterAnnotation(PageableDefault.class);
        if (pageableDefault != null || Pageable.class.isAssignableFrom(originalParameter.getParameterType()) && (this.optionalSpringDataWebProperties.isPresent() || this.optionalRepositoryRestConfiguration.isPresent())) {
            Field field = FieldUtils.getDeclaredField(DelegatingMethodParameter.class, (String)"additionalParameterAnnotations", (boolean)true);
            try {
                Object[] parameterAnnotations = (Annotation[])field.get(methodParameter);
                if (ArrayUtils.isNotEmpty((Object[])parameterAnnotations)) {
                    for (int i = 0; i < parameterAnnotations.length; ++i) {
                        Optional<Annotation> annotationForField;
                        if (!Parameter.class.equals(parameterAnnotations[i].annotationType()) || !(annotationForField = this.getNewParameterAnnotationForField(methodParameter, pageableDefault)).isPresent()) continue;
                        parameterAnnotations[i] = annotationForField.get();
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }

    private Optional<Annotation> getNewParameterAnnotationForField(MethodParameter methodParameter, final PageableDefault pageableDefault) {
        final String parameterName = methodParameter.getParameterName();
        try {
            Field field = methodParameter.getContainingClass().getDeclaredField(parameterName);
            final Parameter parameter = field.getAnnotation(Parameter.class);
            Parameter parameterNew = new Parameter(){

                public Class<? extends Annotation> annotationType() {
                    return parameter.annotationType();
                }

                public String name() {
                    return DataRestDelegatingMethodParameterCustomizer.this.getName(parameterName, parameter.name());
                }

                public ParameterIn in() {
                    return parameter.in();
                }

                public String description() {
                    return parameter.description();
                }

                public boolean required() {
                    return parameter.required();
                }

                public boolean deprecated() {
                    return parameter.deprecated();
                }

                public boolean allowEmptyValue() {
                    return parameter.allowEmptyValue();
                }

                public ParameterStyle style() {
                    return parameter.style();
                }

                public Explode explode() {
                    return parameter.explode();
                }

                public boolean allowReserved() {
                    return parameter.allowReserved();
                }

                public Schema schema() {
                    return new Schema(){

                        public Class<? extends Annotation> annotationType() {
                            return parameter.schema().annotationType();
                        }

                        public Class<?> implementation() {
                            return parameter.schema().implementation();
                        }

                        public Class<?> not() {
                            return parameter.schema().not();
                        }

                        public Class<?>[] oneOf() {
                            return parameter.schema().oneOf();
                        }

                        public Class<?>[] anyOf() {
                            return parameter.schema().anyOf();
                        }

                        public Class<?>[] allOf() {
                            return parameter.schema().allOf();
                        }

                        public String name() {
                            return parameter.schema().name();
                        }

                        public String title() {
                            return parameter.schema().title();
                        }

                        public double multipleOf() {
                            return parameter.schema().multipleOf();
                        }

                        public String maximum() {
                            return parameter.schema().maximum();
                        }

                        public boolean exclusiveMaximum() {
                            return parameter.schema().exclusiveMaximum();
                        }

                        public String minimum() {
                            return parameter.schema().minimum();
                        }

                        public boolean exclusiveMinimum() {
                            return parameter.schema().exclusiveMaximum();
                        }

                        public int maxLength() {
                            return parameter.schema().maxLength();
                        }

                        public int minLength() {
                            return parameter.schema().minLength();
                        }

                        public String pattern() {
                            return parameter.schema().pattern();
                        }

                        public int maxProperties() {
                            return parameter.schema().maxProperties();
                        }

                        public int minProperties() {
                            return parameter.schema().minProperties();
                        }

                        public String[] requiredProperties() {
                            return parameter.schema().requiredProperties();
                        }

                        public boolean required() {
                            return parameter.schema().required();
                        }

                        public String description() {
                            return parameter.schema().description();
                        }

                        public String format() {
                            return parameter.schema().format();
                        }

                        public String ref() {
                            return parameter.schema().ref();
                        }

                        public boolean nullable() {
                            return parameter.schema().nullable();
                        }

                        public boolean readOnly() {
                            return Schema.AccessMode.READ_ONLY.equals((Object)parameter.schema().accessMode());
                        }

                        public boolean writeOnly() {
                            return Schema.AccessMode.WRITE_ONLY.equals((Object)parameter.schema().accessMode());
                        }

                        public Schema.AccessMode accessMode() {
                            return parameter.schema().accessMode();
                        }

                        public String example() {
                            return parameter.schema().example();
                        }

                        public ExternalDocumentation externalDocs() {
                            return parameter.schema().externalDocs();
                        }

                        public boolean deprecated() {
                            return parameter.schema().deprecated();
                        }

                        public String type() {
                            return parameter.schema().type();
                        }

                        public String[] allowableValues() {
                            return parameter.schema().allowableValues();
                        }

                        public String defaultValue() {
                            return DataRestDelegatingMethodParameterCustomizer.this.getDefaultValue(parameterName, pageableDefault, parameter.schema().defaultValue());
                        }

                        public String discriminatorProperty() {
                            return parameter.schema().discriminatorProperty();
                        }

                        public DiscriminatorMapping[] discriminatorMapping() {
                            return parameter.schema().discriminatorMapping();
                        }

                        public boolean hidden() {
                            return parameter.schema().hidden();
                        }

                        public boolean enumAsRef() {
                            return parameter.schema().enumAsRef();
                        }

                        public Class<?>[] subTypes() {
                            return parameter.schema().subTypes();
                        }

                        public Extension[] extensions() {
                            return parameter.schema().extensions();
                        }
                    };
                }

                public ArraySchema array() {
                    final ArraySchema arraySchema = parameter.array();
                    return new ArraySchema(){

                        public Class<? extends Annotation> annotationType() {
                            return arraySchema.annotationType();
                        }

                        public Schema schema() {
                            return arraySchema.schema();
                        }

                        public Schema arraySchema() {
                            final Schema schema = arraySchema.arraySchema();
                            return new Schema(){

                                public Class<? extends Annotation> annotationType() {
                                    return schema.annotationType();
                                }

                                public Class<?> implementation() {
                                    return schema.implementation();
                                }

                                public Class<?> not() {
                                    return schema.not();
                                }

                                public Class<?>[] oneOf() {
                                    return schema.oneOf();
                                }

                                public Class<?>[] anyOf() {
                                    return schema.anyOf();
                                }

                                public Class<?>[] allOf() {
                                    return schema.allOf();
                                }

                                public String name() {
                                    return schema.name();
                                }

                                public String title() {
                                    return schema.title();
                                }

                                public double multipleOf() {
                                    return schema.multipleOf();
                                }

                                public String maximum() {
                                    return schema.maximum();
                                }

                                public boolean exclusiveMaximum() {
                                    return schema.exclusiveMaximum();
                                }

                                public String minimum() {
                                    return schema.minimum();
                                }

                                public boolean exclusiveMinimum() {
                                    return schema.exclusiveMinimum();
                                }

                                public int maxLength() {
                                    return schema.maxLength();
                                }

                                public int minLength() {
                                    return schema.minLength();
                                }

                                public String pattern() {
                                    return schema.pattern();
                                }

                                public int maxProperties() {
                                    return schema.maxProperties();
                                }

                                public int minProperties() {
                                    return schema.minProperties();
                                }

                                public String[] requiredProperties() {
                                    return schema.requiredProperties();
                                }

                                public boolean required() {
                                    return schema.required();
                                }

                                public String description() {
                                    return schema.description();
                                }

                                public String format() {
                                    return schema.format();
                                }

                                public String ref() {
                                    return schema.ref();
                                }

                                public boolean nullable() {
                                    return schema.nullable();
                                }

                                public boolean readOnly() {
                                    return Schema.AccessMode.READ_ONLY.equals((Object)schema.accessMode());
                                }

                                public boolean writeOnly() {
                                    return Schema.AccessMode.WRITE_ONLY.equals((Object)schema.accessMode());
                                }

                                public Schema.AccessMode accessMode() {
                                    return schema.accessMode();
                                }

                                public String example() {
                                    return schema.example();
                                }

                                public ExternalDocumentation externalDocs() {
                                    return schema.externalDocs();
                                }

                                public boolean deprecated() {
                                    return schema.deprecated();
                                }

                                public String type() {
                                    return schema.type();
                                }

                                public String[] allowableValues() {
                                    return schema.allowableValues();
                                }

                                public String defaultValue() {
                                    return DataRestDelegatingMethodParameterCustomizer.this.getArrayDefaultValue(parameterName, pageableDefault, schema.defaultValue());
                                }

                                public String discriminatorProperty() {
                                    return schema.discriminatorProperty();
                                }

                                public DiscriminatorMapping[] discriminatorMapping() {
                                    return schema.discriminatorMapping();
                                }

                                public boolean hidden() {
                                    return schema.hidden();
                                }

                                public boolean enumAsRef() {
                                    return schema.enumAsRef();
                                }

                                public Class<?>[] subTypes() {
                                    return schema.subTypes();
                                }

                                public Extension[] extensions() {
                                    return schema.extensions();
                                }
                            };
                        }

                        public int maxItems() {
                            return arraySchema.maxItems();
                        }

                        public int minItems() {
                            return arraySchema.minItems();
                        }

                        public boolean uniqueItems() {
                            return arraySchema.uniqueItems();
                        }

                        public Extension[] extensions() {
                            return arraySchema.extensions();
                        }
                    };
                }

                public Content[] content() {
                    return parameter.content();
                }

                public boolean hidden() {
                    return parameter.hidden();
                }

                public ExampleObject[] examples() {
                    return parameter.examples();
                }

                public String example() {
                    return parameter.example();
                }

                public Extension[] extensions() {
                    return parameter.extensions();
                }

                public String ref() {
                    return parameter.ref();
                }
            };
            return Optional.of(parameterNew);
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn(e.getMessage());
            return Optional.empty();
        }
    }

    private String getName(String parameterName, String originalName) {
        String name = null;
        switch (parameterName) {
            case "size": {
                if (this.optionalRepositoryRestConfiguration.isPresent()) {
                    name = this.optionalRepositoryRestConfiguration.get().getLimitParamName();
                    break;
                }
                if (this.optionalSpringDataWebProperties.isPresent()) {
                    name = this.optionalSpringDataWebProperties.get().getPageable().getSizeParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "sort": {
                if (this.optionalRepositoryRestConfiguration.isPresent()) {
                    name = this.optionalRepositoryRestConfiguration.get().getSortParamName();
                    break;
                }
                if (this.optionalSpringDataWebProperties.isPresent()) {
                    name = this.optionalSpringDataWebProperties.get().getSort().getSortParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "page": {
                if (this.optionalRepositoryRestConfiguration.isPresent()) {
                    name = this.optionalRepositoryRestConfiguration.get().getPageParamName();
                    break;
                }
                if (this.optionalSpringDataWebProperties.isPresent()) {
                    name = this.optionalSpringDataWebProperties.get().getPageable().getPageParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "direction": {
                name = originalName;
                break;
            }
        }
        return name;
    }

    private String getDefaultValue(String parameterName, PageableDefault pageableDefault, String defaultSchemaVal) {
        String defaultValue = null;
        switch (parameterName) {
            case "size": {
                if (pageableDefault != null) {
                    defaultValue = String.valueOf(pageableDefault.size());
                    break;
                }
                if (this.optionalRepositoryRestConfiguration.isPresent()) {
                    defaultValue = String.valueOf(this.optionalRepositoryRestConfiguration.get().getDefaultPageSize());
                    break;
                }
                if (this.optionalSpringDataWebProperties.isPresent()) {
                    defaultValue = String.valueOf(this.optionalSpringDataWebProperties.get().getPageable().getDefaultPageSize());
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
            case "page": {
                if (pageableDefault != null) {
                    defaultValue = String.valueOf(pageableDefault.page());
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
        }
        return defaultValue;
    }

    private String getArrayDefaultValue(String parameterName, PageableDefault pageableDefault, String defaultSchemaVal) {
        String defaultValue = defaultSchemaVal;
        if ("sort".equals(parameterName) && pageableDefault != null && ArrayUtils.isNotEmpty((Object[])pageableDefault.sort())) {
            ArrayList<String> sortValues = new ArrayList<String>();
            for (String sortValue : pageableDefault.sort()) {
                String sortStr = String.join((CharSequence)",", sortValue, pageableDefault.direction().name());
                sortValues.add(sortStr);
            }
            try {
                defaultValue = ObjectMapperFactory.buildStrictGenericObjectMapper().writeValueAsString(sortValues);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return defaultValue;
    }
}

