/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.utils;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springdoc.data.rest.utils.EntityInfo;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.util.CollectionUtils;

public class SpringDocDataRestUtils {
    private static final String REQUEST_BODY = "RequestBody";
    private static final String RESPONSE = "Response";
    private static final String EMBEDDED = "_embedded";
    private LinkRelationProvider linkRelationProvider;
    private HashMap<String, EntityInfo> entityInoMap = new HashMap();

    public SpringDocDataRestUtils(LinkRelationProvider linkRelationProvider) {
        this.linkRelationProvider = linkRelationProvider;
    }

    public void customise(OpenAPI openAPI, ResourceMappings mappings, PersistentEntities persistentEntities) {
        persistentEntities.getManagedTypes().stream().forEach(typeInformation -> {
            Class domainType = typeInformation.getType();
            ResourceMetadata resourceMetadata = mappings.getMetadataFor(domainType);
            PersistentEntity entity = persistentEntities.getRequiredPersistentEntity(domainType);
            EntityInfo entityInfo = new EntityInfo();
            entityInfo.setDomainType(domainType);
            List<String> ignoredFields = this.getIgnoredFields(resourceMetadata, entity);
            entityInfo.setIgnoredFields(ignoredFields);
            List<String> associationsFields = this.getAssociationsFields(resourceMetadata, entity);
            entityInfo.setAssociationsFields(associationsFields);
            this.entityInoMap.put(domainType.getSimpleName(), entityInfo);
        });
        openAPI.getPaths().entrySet().stream().forEach(stringPathItemEntry -> {
            PathItem pathItem = (PathItem)stringPathItemEntry.getValue();
            pathItem.readOperations().forEach(operation -> {
                RequestBody requestBody = operation.getRequestBody();
                this.updateRequestBody(openAPI, requestBody);
                ApiResponses apiResponses = operation.getResponses();
                apiResponses.forEach((code, apiResponse) -> this.updateApiResponse(openAPI, openAPI.getComponents(), (ApiResponse)apiResponse));
            });
        });
    }

    private void updateApiResponse(OpenAPI openAPI, Components components, ApiResponse apiResponse) {
        if (apiResponse != null && !CollectionUtils.isEmpty((Map)apiResponse.getContent())) {
            apiResponse.getContent().values().forEach(mediaType -> {
                Schema schema = mediaType.getSchema();
                if (schema.get$ref() != null && !schema.get$ref().endsWith(RESPONSE)) {
                    String key = schema.get$ref().substring(21);
                    Set<String> entitiesNames = this.entityInoMap.keySet();
                    entitiesNames.forEach(entityName -> {
                        if (key.endsWith((String)entityName)) {
                            this.updateResponseSchema((String)entityName, (Schema)components.getSchemas().get(key), openAPI.getComponents());
                        }
                    });
                }
            });
        }
    }

    private void updateRequestBody(OpenAPI openAPI, RequestBody requestBody) {
        if (requestBody != null && !CollectionUtils.isEmpty((Map)requestBody.getContent())) {
            requestBody.getContent().values().forEach(mediaType -> {
                Schema schema = mediaType.getSchema();
                if (schema.get$ref() != null && !schema.get$ref().endsWith(REQUEST_BODY)) {
                    String key = schema.get$ref().substring(21);
                    if (this.entityInoMap.keySet().contains(key)) {
                        this.updateRequestBodySchema(key, schema, openAPI.getComponents());
                    }
                } else if (schema instanceof ComposedSchema) {
                    this.updateComposedSchema((ComposedSchema)schema, REQUEST_BODY, openAPI.getComponents());
                }
            });
        }
    }

    private void updateRequestBodySchema(String className, Schema schema, Components components) {
        Map schemaMap;
        String newKey = className + REQUEST_BODY;
        schema.set$ref(newKey);
        Class<?> schemaImplementation = this.entityInoMap.get(className).getDomainType();
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation));
        if (resolvedSchema != null && (schemaMap = resolvedSchema.referencedSchemas) != null) {
            schemaMap.forEach((key, referencedSchema) -> {
                components.addSchemas(key + REQUEST_BODY, referencedSchema);
                referencedSchema.setName(key + REQUEST_BODY);
                Map properties = referencedSchema.getProperties();
                this.updateRequestBodySchemaProperties((String)key, (Schema)referencedSchema, properties);
                if (referencedSchema instanceof ComposedSchema) {
                    this.updateComposedSchema((ComposedSchema)referencedSchema, REQUEST_BODY, components);
                }
            });
        }
    }

    private void updateRequestBodySchemaProperties(String key, Schema referencedSchema, Map properties) {
        if (!CollectionUtils.isEmpty((Map)referencedSchema.getProperties())) {
            for (Map.Entry entry : properties.entrySet()) {
                String propId = (String)entry.getKey();
                if (!this.entityInoMap.containsKey(key) || !this.entityInoMap.get(key).getAssociationsFields().contains(propId)) continue;
                if (entry.getValue() instanceof ArraySchema) {
                    referencedSchema.addProperties(propId, (Schema)new ArraySchema().items((Schema)new StringSchema()));
                    continue;
                }
                referencedSchema.addProperties(propId, (Schema)new StringSchema());
            }
        }
    }

    private Schema updateResponseSchema(String className, Schema existingSchema, Components components) {
        Map properties = existingSchema.getProperties();
        EntityInfo entityInfo = this.entityInoMap.get(className);
        if (!CollectionUtils.isEmpty((Map)properties)) {
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Schema> entry = it.next();
                String propId = (String)entry.getKey();
                if (entityInfo.getIgnoredFields().contains(propId)) {
                    it.remove();
                    continue;
                }
                if (!EMBEDDED.equals(propId)) continue;
                this.updateResponseSchemaEmbedded(components, entityInfo, entry);
            }
        }
        return existingSchema;
    }

    private void updateResponseSchemaEmbedded(Components components, EntityInfo entityInfo, Map.Entry<String, Schema> entry) {
        String entityClassName = this.linkRelationProvider.getCollectionResourceRelFor(entityInfo.getDomainType()).value();
        ArraySchema arraySchema = (ArraySchema)((ObjectSchema)entry.getValue()).getProperties().get(entityClassName);
        if (arraySchema != null) {
            Schema itemsSchema = arraySchema.getItems();
            Set<String> entitiesNames = this.entityInoMap.keySet();
            if (itemsSchema.get$ref() != null && !itemsSchema.get$ref().endsWith(RESPONSE)) {
                String key = itemsSchema.get$ref().substring(21);
                if (entitiesNames.contains(key)) {
                    String newKey = itemsSchema.get$ref() + RESPONSE;
                    this.createNewResponseSchema(key, components);
                    itemsSchema.set$ref(newKey);
                }
            } else if (itemsSchema instanceof ComposedSchema) {
                this.updateComposedSchema((ComposedSchema)itemsSchema, RESPONSE, components);
            }
        }
    }

    private Schema createNewResponseSchema(String className, Components components) {
        Class<?> schemaImplementation = this.entityInoMap.get(className).getDomainType();
        Schema schemaObject = new Schema();
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation));
        if (resolvedSchema != null) {
            Map schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap != null) {
                schemaMap.forEach((key, referencedSchema) -> this.addSchemas(components, (String)key, (Schema)referencedSchema));
            }
            schemaObject = resolvedSchema.schema;
        }
        return schemaObject;
    }

    private void addSchemas(Components components, String key, Schema referencedSchema) {
        Map properties = referencedSchema.getProperties();
        if (!CollectionUtils.isEmpty((Map)referencedSchema.getProperties())) {
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String propId = (String)entry.getKey();
                if (!this.entityInoMap.containsKey(key) || !this.entityInoMap.get(key).getIgnoredFields().contains(propId)) continue;
                it.remove();
            }
        }
        if (referencedSchema instanceof ComposedSchema) {
            this.updateComposedSchema((ComposedSchema)referencedSchema, RESPONSE, null);
        }
        components.addSchemas(key + RESPONSE, referencedSchema);
    }

    private void updateComposedSchema(ComposedSchema referencedSchema, String suffix, Components components) {
        ComposedSchema composedSchema = referencedSchema;
        List allOfSchemas = composedSchema.getAllOf();
        this.updateKey(allOfSchemas, suffix, components);
        List oneOfSchemas = composedSchema.getOneOf();
        this.updateKey(oneOfSchemas, suffix, components);
    }

    private void updateKey(List<Schema> allSchemas, String suffix, Components components) {
        if (!CollectionUtils.isEmpty(allSchemas)) {
            for (Schema allSchema : allSchemas) {
                if (allSchema.get$ref() == null) continue;
                String allKey = allSchema.get$ref().substring(21);
                this.updateSingleKey(suffix, components, allSchema, allKey);
            }
        }
    }

    private void updateSingleKey(String suffix, Components components, Schema allSchema, String allKey) {
        if (!allKey.endsWith(REQUEST_BODY) && !allKey.endsWith(RESPONSE)) {
            String newAllKey = allKey + suffix;
            allSchema.set$ref(newAllKey);
            if (components != null && !components.getSchemas().containsKey(newAllKey) && this.entityInoMap.containsKey(allKey) && RESPONSE.equals(suffix)) {
                this.createNewResponseSchema(allKey, components);
            }
        }
    }

    private List<String> getAssociationsFields(ResourceMetadata resourceMetadata, PersistentEntity<?, ?> entity) {
        ArrayList<String> associationsFields = new ArrayList<String>();
        entity.doWithAssociations(association -> {
            PersistentProperty property = association.getInverse();
            String filedName = resourceMetadata.getMappingFor(property).getRel().value();
            associationsFields.add(filedName);
        });
        return associationsFields;
    }

    private List<String> getIgnoredFields(ResourceMetadata resourceMetadata, PersistentEntity<?, ?> entity) {
        ArrayList<String> ignoredFields = new ArrayList<String>();
        if (entity != null && entity.getIdProperty() != null) {
            String idField = Objects.requireNonNull(entity.getIdProperty()).getName();
            ignoredFields.add(idField);
            entity.doWithAssociations(association -> {
                PersistentProperty property = association.getInverse();
                String filedName = resourceMetadata.getMappingFor(property).getRel().value();
                ignoredFields.add(filedName);
            });
        }
        return ignoredFields;
    }

    public void buildTextUriContent(Content content) {
        content.computeIfPresent((Object)"text/uri-list", (key, value) -> new MediaType().schema((Schema)new StringSchema()));
    }
}

