/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.models.Operation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.SecurityParser;
import org.springdoc.data.rest.core.DataRestRepository;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

public class DataRestTagsBuilder {
    private final OpenAPIBuilder openAPIBuilder;

    public DataRestTagsBuilder(OpenAPIBuilder openAPIBuilder) {
        this.openAPIBuilder = openAPIBuilder;
    }

    public void buildSearchTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository) {
        this.buildTags(operation, handlerMethod, dataRestRepository);
    }

    public void buildEntityTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository) {
        this.buildTags(operation, handlerMethod, dataRestRepository);
    }

    private void buildTags(Operation operation, HandlerMethod handlerMethod, DataRestRepository dataRestRepository) {
        String tagName = handlerMethod.getBeanType().getSimpleName();
        if ("org.springframework.data.rest.webmvc.RepositorySchemaController".equals(handlerMethod.getBeanType().getName()) || AlpsController.class.equals((Object)handlerMethod.getBeanType()) || ProfileController.class.equals((Object)handlerMethod.getBeanType())) {
            tagName = ProfileController.class.getSimpleName();
            operation.addTagsItem(OpenAPIBuilder.splitCamelCase((String)tagName));
        } else if (dataRestRepository != null && dataRestRepository.getDomainType() != null) {
            Class<?> domainType = dataRestRepository.getDomainType();
            HashSet tags = new HashSet();
            HashSet tagsStr = new HashSet();
            Class<?> repositoryType = dataRestRepository.getRepositoryType();
            this.openAPIBuilder.buildTagsFromClass(repositoryType, tags, tagsStr);
            if (!CollectionUtils.isEmpty(tagsStr)) {
                tagsStr.forEach(arg_0 -> ((Operation)operation).addTagsItem(arg_0));
            } else {
                tagName = tagName.replace("Repository", domainType.getSimpleName());
                operation.addTagsItem(OpenAPIBuilder.splitCamelCase((String)tagName));
            }
            SecurityParser securityParser = this.openAPIBuilder.getSecurityParser();
            Set allSecurityTags = securityParser.getSecurityRequirementsForClass(repositoryType);
            if (!CollectionUtils.isEmpty((Collection)allSecurityTags)) {
                securityParser.buildSecurityRequirement(allSecurityTags.toArray(new SecurityRequirement[0]), operation);
            }
        }
    }
}

