/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.RepositoryRestResourceProvider;
import org.springdoc.core.fn.RouterOperation;
import org.springdoc.data.rest.core.DataRestRouterOperationBuilder;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class SpringRepositoryRestResourceProvider
implements RepositoryRestResourceProvider {
    public static final String REPOSITORY_ENTITY_CONTROLLER = "org.springframework.data.rest.webmvc.RepositoryEntityController";
    public static final String REPOSITORY_SERACH_CONTROLLER = "org.springframework.data.rest.webmvc.RepositorySearchController";
    public static final String REPOSITORY_SCHEMA_CONTROLLER = "org.springframework.data.rest.webmvc.RepositorySchemaController";
    public static final String REPOSITORY_PROPERTY_CONTROLLER = "org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController";
    private ResourceMappings mappings;
    private Repositories repositories;
    private Associations associations;
    private DelegatingHandlerMapping delegatingHandlerMapping;
    private DataRestRouterOperationBuilder dataRestRouterOperationBuilder;

    public SpringRepositoryRestResourceProvider(ResourceMappings mappings, Repositories repositories, Associations associations, DelegatingHandlerMapping delegatingHandlerMapping, DataRestRouterOperationBuilder dataRestRouterOperationBuilder) {
        this.mappings = mappings;
        this.repositories = repositories;
        this.associations = associations;
        this.delegatingHandlerMapping = delegatingHandlerMapping;
        this.dataRestRouterOperationBuilder = dataRestRouterOperationBuilder;
    }

    public List<RouterOperation> getRouterOperations(OpenAPI openAPI) {
        ArrayList<RouterOperation> routerOperationList = new ArrayList<RouterOperation>();
        List handlerMappingList = this.delegatingHandlerMapping.getDelegates();
        for (Class domainType : this.repositories) {
            ResourceMetadata resourceMetadata = this.mappings.getMetadataFor(domainType);
            if (resourceMetadata.isExported()) {
                for (HandlerMapping handlerMapping : handlerMappingList) {
                    Map<RequestMappingInfo, HandlerMethod> handlerMethodMapFiltered;
                    Map handlerMethodMap;
                    if (handlerMapping instanceof RepositoryRestHandlerMapping) {
                        RepositoryRestHandlerMapping repositoryRestHandlerMapping = (RepositoryRestHandlerMapping)handlerMapping;
                        handlerMethodMap = repositoryRestHandlerMapping.getHandlerMethods();
                        handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_ENTITY_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName()) || REPOSITORY_PROPERTY_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).filter(controller -> !AbstractOpenApiResource.isHiddenRestControllers((Class)((HandlerMethod)controller.getValue()).getBeanType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                        this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, domainType, openAPI);
                        continue;
                    }
                    if (!(handlerMapping instanceof BasePathAwareHandlerMapping)) continue;
                    BasePathAwareHandlerMapping beanBasePathAwareHandlerMapping = (BasePathAwareHandlerMapping)handlerMapping;
                    handlerMethodMap = beanBasePathAwareHandlerMapping.getHandlerMethods();
                    handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_SCHEMA_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).filter(controller -> !AbstractOpenApiResource.isHiddenRestControllers((Class)((HandlerMethod)controller.getValue()).getBeanType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                    this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, domainType, openAPI);
                    handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> ProfileController.class.equals((Object)((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType()) || AlpsController.class.equals((Object)((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                    this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, null, openAPI);
                }
            }
            this.findSearchResourceMappings(openAPI, routerOperationList, handlerMappingList, domainType, resourceMetadata);
        }
        return routerOperationList;
    }

    private void findSearchResourceMappings(OpenAPI openAPI, List<RouterOperation> routerOperationList, List<HandlerMapping> handlerMappingList, Class<?> domainType, ResourceMetadata resourceMetadata) {
        for (HandlerMapping handlerMapping : handlerMappingList) {
            if (!(handlerMapping instanceof RepositoryRestHandlerMapping)) continue;
            RepositoryRestHandlerMapping repositoryRestHandlerMapping = (RepositoryRestHandlerMapping)handlerMapping;
            Map handlerMethodMap = repositoryRestHandlerMapping.getHandlerMethods();
            Map<RequestMappingInfo, HandlerMethod> handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_SERACH_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).filter(controller -> !AbstractOpenApiResource.isHiddenRestControllers((Class)((HandlerMethod)controller.getValue()).getBeanType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            ResourceMetadata metadata = this.associations.getMetadataFor(domainType);
            SearchResourceMappings searchResourceMappings = metadata.getSearchResourceMappings();
            if (!searchResourceMappings.isExported()) continue;
            this.findSearchControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, domainType, openAPI, searchResourceMappings);
        }
    }

    private List<RouterOperation> findSearchControllers(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, Class<?> domainType, OpenAPI openAPI, SearchResourceMappings searchResourceMappings) {
        Stream methodResourceMappingStream = searchResourceMappings.getExportedMappings();
        methodResourceMappingStream.forEach(methodResourceMapping -> this.dataRestRouterOperationBuilder.buildSearchRouterOperationList(routerOperationList, handlerMethodMap, resourceMetadata, domainType, openAPI, (MethodResourceMapping)methodResourceMapping));
        return routerOperationList;
    }

    private List<RouterOperation> findControllers(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, Class<?> domainType, OpenAPI openAPI) {
        this.dataRestRouterOperationBuilder.buildEntityRouterOperationList(routerOperationList, handlerMethodMap, resourceMetadata, domainType, openAPI);
        return routerOperationList;
    }
}

