/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import org.springdoc.core.OpenAPIBuilder;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.web.method.HandlerMethod;

public class DataRestTagsBuilder {
    private OpenAPIBuilder openAPIBuilder;

    public DataRestTagsBuilder(OpenAPIBuilder openAPIBuilder) {
        this.openAPIBuilder = openAPIBuilder;
    }

    public void buildSearchTags(Operation operation, OpenAPI openAPI, HandlerMethod handlerMethod, Class<?> domainType) {
        this.buildTags(operation, openAPI, handlerMethod, domainType);
    }

    public void buildEntityTags(Operation operation, OpenAPI openAPI, HandlerMethod handlerMethod, Class<?> domainType) {
        this.buildTags(operation, openAPI, handlerMethod, domainType);
    }

    private void buildTags(Operation operation, OpenAPI openAPI, HandlerMethod handlerMethod, Class<?> domainType) {
        if (this.openAPIBuilder.isAutoTagClasses(operation)) {
            String tagName = handlerMethod.getBeanType().getSimpleName();
            if ("org.springframework.data.rest.webmvc.RepositorySchemaController".equals(handlerMethod.getBeanType().getName()) || AlpsController.class.equals((Object)handlerMethod.getBeanType())) {
                tagName = ProfileController.class.getSimpleName();
            } else if (domainType != null) {
                tagName = tagName.replace("Repository", domainType.getSimpleName());
            }
            operation.addTagsItem(OpenAPIBuilder.splitCamelCase((String)tagName));
        }
        this.openAPIBuilder.buildTags(handlerMethod, operation, openAPI);
    }
}

