/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.converters;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Min;

public class Pageable {
    @Min(value=0L)
    @Parameter(description="Zero-based page index (0..N)", schema=@Schema(type="integer", defaultValue="0"))
    private @Min(value=0L) Integer page;
    @Min(value=1L)
    @Parameter(description="The size of the page to be returned", schema=@Schema(type="integer", defaultValue="20"))
    private @Min(value=1L) Integer size;
    @Parameter(description="Sorting criteria in the format: property(,asc|desc). Default sort order is ascending. Multiple sort criteria are supported.", name="sort", array=@ArraySchema(schema=@Schema(type="string")))
    private List<String> sort;

    public Pageable(int page, int size, List<String> sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<String> getSort() {
        return this.sort;
    }

    public void setSort(List<String> sort) {
        if (sort == null) {
            this.sort.clear();
        } else {
            this.sort = sort;
        }
    }

    public void addSort(String sort) {
        this.sort.add(sort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pageable pageable = (Pageable)o;
        return Objects.equals(this.page, pageable.page) && Objects.equals(this.size, pageable.size) && Objects.equals(this.sort, pageable.sort);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.size, this.sort);
    }

    public String toString() {
        return "Pageable{page=" + this.page + ", size=" + this.size + ", sort=" + this.sort + '}';
    }
}

