/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.customisers;

import com.querydsl.core.types.Path;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.core.MethodParameter;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.util.CastUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.web.method.HandlerMethod;

public class QuerydslPredicateOperationCustomizer
implements OperationCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerydslPredicateOperationCustomizer.class);
    private static final String ACCESS_EXCEPTION_OCCURRED = "NoSuchFieldException or IllegalAccessException occurred : {}";
    private QuerydslBindingsFactory querydslBindingsFactory;

    public QuerydslPredicateOperationCustomizer(QuerydslBindingsFactory querydslBindingsFactory) {
        this.querydslBindingsFactory = querydslBindingsFactory;
    }

    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        if (operation.getParameters() == null) {
            return operation;
        }
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        int parametersLength = methodParameters.length;
        ArrayList<Parameter> parametersToAddToOperation = new ArrayList<Parameter>();
        for (int i = 0; i < parametersLength; ++i) {
            MethodParameter parameter = methodParameters[i];
            QuerydslPredicate predicate = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
            if (predicate == null) continue;
            QuerydslBindings bindings = this.extractQdslBindings(predicate);
            Set fieldsToAdd = Arrays.stream(predicate.root().getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
            Map<String, Object> pathSpecMap = this.getPathSpec(bindings, "pathSpecs");
            Set<String> blacklist = this.getFieldValues(bindings, "blackList");
            fieldsToAdd.removeIf(blacklist::contains);
            Set<String> whiteList = this.getFieldValues(bindings, "whiteList");
            Set<String> aliases = this.getFieldValues(bindings, "aliases");
            fieldsToAdd.addAll(aliases);
            fieldsToAdd.addAll(whiteList);
            for (String fieldName : fieldsToAdd) {
                Type type = this.getFieldType(fieldName, pathSpecMap, predicate.root());
                Parameter newParameter = this.buildParam(type, fieldName);
                parametersToAddToOperation.add(newParameter);
            }
        }
        operation.getParameters().addAll(parametersToAddToOperation);
        return operation;
    }

    private QuerydslBindings extractQdslBindings(QuerydslPredicate predicate) {
        ClassTypeInformation classTypeInformation = ClassTypeInformation.from((Class)predicate.root());
        TypeInformation domainType = classTypeInformation.getRequiredActualType();
        Optional<Class> bindingsAnnotation = Optional.of(predicate).map(QuerydslPredicate::bindings).map(CastUtils::cast);
        return bindingsAnnotation.map(it -> this.querydslBindingsFactory.createBindingsFor(domainType, it)).orElseGet(() -> this.querydslBindingsFactory.createBindingsFor(domainType));
    }

    private Set<String> getFieldValues(QuerydslBindings instance, String fieldName) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            return (Set)field.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.warn(ACCESS_EXCEPTION_OCCURRED, (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    private Map<String, Object> getPathSpec(QuerydslBindings instance, String fieldName) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            return (Map)field.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.warn(ACCESS_EXCEPTION_OCCURRED, (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    private Optional<Path<?>> getPathFromPathSpec(Object instance) {
        try {
            if (instance == null) {
                return Optional.empty();
            }
            Field field = instance.getClass().getDeclaredField("path");
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            return (Optional)field.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.warn(ACCESS_EXCEPTION_OCCURRED, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private Type getFieldType(String fieldName, Map<String, Object> pathSpecMap, Class<?> root) {
        try {
            Type genericType;
            Object pathAndBinding = pathSpecMap.get(fieldName);
            Optional<Path<?>> path = this.getPathFromPathSpec(pathAndBinding);
            Field declaredField = null;
            if (path.isPresent()) {
                genericType = path.get().getType();
            } else {
                declaredField = root.getDeclaredField(fieldName);
                genericType = declaredField.getGenericType();
            }
            if (genericType != null) {
                return genericType;
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn("Field {} not found on {} : {}", new Object[]{fieldName, root.getName(), e.getMessage()});
        }
        return String.class;
    }

    private Parameter buildParam(Type type, String name) {
        Parameter parameter = new Parameter();
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn("query");
        }
        if (parameter.getSchema() == null) {
            ResolvedSchema resolvedSchema;
            Schema schema = null;
            PrimitiveType primitiveType = PrimitiveType.fromType((Type)type);
            schema = primitiveType != null ? primitiveType.createProperty() : ((resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(type).resolveAsRef(true))) == null || !resolvedSchema.referencedSchemas.isEmpty() ? PrimitiveType.fromType(String.class).createProperty() : resolvedSchema.schema);
            parameter.setSchema(schema);
        }
        return parameter;
    }
}

