/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.converters;

import com.fasterxml.jackson.databind.type.CollectionType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.LinkRelationProvider;

public class CollectionModelContentConverter
implements ModelConverter {
    private LinkRelationProvider linkRelationProvider;

    public CollectionModelContentConverter(LinkRelationProvider linkRelationProvider) {
        this.linkRelationProvider = linkRelationProvider;
    }

    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Schema schema;
        if (chain.hasNext() && type != null && type.getType() instanceof CollectionType && "_embedded".equalsIgnoreCase(type.getPropertyName()) && (schema = chain.next().resolve(type, context, chain)) instanceof ArraySchema) {
            Class<?> entityType = this.getEntityType(type);
            String entityClassName = this.linkRelationProvider.getCollectionResourceRelFor(entityType).value();
            return new ObjectSchema().name("_embedded").addProperties(entityClassName, schema);
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }

    private Class<?> getEntityType(AnnotatedType type) {
        Class containerEntityType = ((CollectionType)type.getType()).getContentType().getRawClass();
        if (containerEntityType.isAssignableFrom(EntityModel.class)) {
            return ((CollectionType)type.getType()).getContentType().getBindings().getBoundType(0).getRawClass();
        }
        return containerEntityType;
    }
}

