/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest;

import com.querydsl.core.types.Predicate;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Optional;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.data.rest.HalProvider;
import org.springdoc.data.rest.converters.CollectionModelContentConverter;
import org.springdoc.data.rest.converters.Pageable;
import org.springdoc.data.rest.converters.RepresentationModelLinksOASMixin;
import org.springdoc.data.rest.customisers.QuerydslPredicateOperationCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.LinkRelationProvider;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocDataRestConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    HalProvider halProvider(Optional<RepositoryRestConfiguration> repositoryRestConfiguration) {
        return new HalProvider(repositoryRestConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    CollectionModelContentConverter collectionModelContentConverter(HalProvider halProvider, LinkRelationProvider linkRelationProvider) {
        return halProvider.isHalEnabled() ? new CollectionModelContentConverter(linkRelationProvider) : null;
    }

    @Bean
    @Lazy(value=false)
    OpenApiCustomiser linksSchemaCustomiser(HalProvider halProvider) {
        if (!halProvider.isHalEnabled()) {
            return openApi -> {};
        }
        Json.mapper().addMixIn(RepresentationModel.class, RepresentationModelLinksOASMixin.class);
        ResolvedSchema resolvedLinkSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(Link.class).resolveAsRef(true));
        return openApi -> openApi.schema("Link", resolvedLinkSchema.schema).schema("Links", new MapSchema().additionalProperties((Object)new StringSchema()).additionalProperties((Object)new ObjectSchema().$ref("#/components/schemas/Link")));
    }

    static {
        SpringDocUtils.getConfig().replaceWithClass(org.springframework.data.domain.Pageable.class, Pageable.class).replaceWithClass(PageRequest.class, Pageable.class);
    }

    @ConditionalOnClass(value={QuerydslBindingsFactory.class})
    class QuerydslProvider {
        QuerydslProvider() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        QuerydslPredicateOperationCustomizer queryDslQuerydslPredicateOperationCustomizer(Optional<QuerydslBindingsFactory> querydslBindingsFactory) {
            if (querydslBindingsFactory.isPresent()) {
                SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{Predicate.class});
                return new QuerydslPredicateOperationCustomizer(querydslBindingsFactory.get());
            }
            return null;
        }
    }
}

