/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;

public class HalProvider {
    private Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional;

    public HalProvider(Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional) {
        this.repositoryRestConfigurationOptional = repositoryRestConfigurationOptional;
    }

    @PostConstruct
    private void init() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)Json.mapper())) {
            Json.mapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    public boolean isHalEnabled() {
        return this.repositoryRestConfigurationOptional.map(RepositoryRestConfiguration::useHalAsDefaultJsonMediaType).orElse(true);
    }
}

