/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn.builders.schema;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.ArrayUtils;

public class Builder {
    private Class<?> implementation = Void.class;
    private Class<?> not = Void.class;
    private Class<?>[] oneOf = new Class[0];
    private Class<?>[] anyOf = new Class[0];
    private Class<?>[] allOf = new Class[0];
    private String name = "";
    private String title = "";
    private double multipleOf = 0.0;
    private String maximum = "";
    private boolean exclusiveMaximum;
    private String minimum = "";
    private boolean exclusiveMinimum;
    private int maxLength = Integer.MAX_VALUE;
    private int minLength = 0;
    private String pattern = "";
    private int maxProperties = 0;
    private int minProperties = 0;
    private String[] requiredProperties = new String[0];
    private boolean required;
    private String description = "";
    private String format = "";
    private String ref = "";
    private boolean nullable;
    private Schema.AccessMode accessMode = Schema.AccessMode.AUTO;
    private String example = "";
    private ExternalDocumentation externalDocs = org.springdoc.core.fn.builders.externaldocumentation.Builder.externalDocumentationBuilder().build();
    private boolean deprecated;
    private String type = "";
    private String[] allowableValues = new String[0];
    private String defaultValue = "";
    private String discriminatorProperty = "";
    private DiscriminatorMapping[] discriminatorMapping = new DiscriminatorMapping[0];
    private boolean hidden;
    private boolean enumAsRef;
    private Class<?>[] subTypes = new Class[0];
    private Extension[] extensions = new Extension[0];

    private Builder() {
    }

    public static Builder schemaBuilder() {
        return new Builder();
    }

    public Builder implementation(Class<?> implementation) {
        this.implementation = implementation;
        return this;
    }

    public Builder not(Class<?> not) {
        this.not = not;
        return this;
    }

    public Builder oneOf(Class<?>[] oneOf) {
        this.oneOf = oneOf;
        return this;
    }

    public Builder anyOf(Class<?>[] anyOf) {
        this.anyOf = anyOf;
        return this;
    }

    public Builder allOf(Class<?>[] allOf) {
        this.allOf = allOf;
        return this;
    }

    public Builder name(String name) {
        this.name = name;
        return this;
    }

    public Builder title(String title) {
        this.title = title;
        return this;
    }

    public Builder multipleOf(double multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Builder maximum(String maximum) {
        this.maximum = maximum;
        return this;
    }

    public Builder exclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Builder minimum(String minimum) {
        this.minimum = minimum;
        return this;
    }

    public Builder exclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Builder maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Builder minLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public Builder pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Builder maxProperties(int maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Builder minProperties(int minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public Builder requiredProperties(String[] requiredProperties) {
        this.requiredProperties = requiredProperties;
        return this;
    }

    public Builder required(boolean required) {
        this.required = required;
        return this;
    }

    public Builder description(String description) {
        this.description = description;
        return this;
    }

    public Builder format(String format) {
        this.format = format;
        return this;
    }

    public Builder ref(String ref) {
        this.ref = ref;
        return this;
    }

    public Builder nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Builder accessMode(Schema.AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public Builder example(String example) {
        this.example = example;
        return this;
    }

    public Builder externalDocs(org.springdoc.core.fn.builders.externaldocumentation.Builder externalDocumentationBuilder) {
        this.externalDocs = externalDocumentationBuilder.build();
        return this;
    }

    public Builder deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Builder type(String type) {
        this.type = type;
        return this;
    }

    public Builder allowableValues(String[] allowableValues) {
        this.allowableValues = allowableValues;
        return this;
    }

    public Builder defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Builder discriminatorProperty(String discriminatorProperty) {
        this.discriminatorProperty = discriminatorProperty;
        return this;
    }

    public Builder discriminatorMapping(org.springdoc.core.fn.builders.discriminatormapping.Builder discriminatorMappingBuilder) {
        this.discriminatorMapping = (DiscriminatorMapping[])ArrayUtils.add((Object[])this.discriminatorMapping, (Object)discriminatorMappingBuilder.build());
        return this;
    }

    public Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Builder enumAsRef(boolean enumAsRef) {
        this.enumAsRef = enumAsRef;
        return this;
    }

    public Builder subTypes(Class<?>[] subTypes) {
        this.subTypes = subTypes;
        return this;
    }

    public Builder extensions(org.springdoc.core.fn.builders.extension.Builder extensionBuilder) {
        this.extensions = (Extension[])ArrayUtils.add((Object[])this.extensions, (Object)extensionBuilder.build());
        return this;
    }

    public Schema build() {
        return new Schema(){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public Class<?> implementation() {
                return Builder.this.implementation;
            }

            public Class<?> not() {
                return Builder.this.not;
            }

            public Class<?>[] oneOf() {
                return Builder.this.oneOf;
            }

            public Class<?>[] anyOf() {
                return Builder.this.anyOf;
            }

            public Class<?>[] allOf() {
                return Builder.this.allOf;
            }

            public String name() {
                return Builder.this.name;
            }

            public String title() {
                return Builder.this.title;
            }

            public double multipleOf() {
                return Builder.this.multipleOf;
            }

            public String maximum() {
                return Builder.this.maximum;
            }

            public boolean exclusiveMaximum() {
                return Builder.this.exclusiveMaximum;
            }

            public String minimum() {
                return Builder.this.minimum;
            }

            public boolean exclusiveMinimum() {
                return Builder.this.exclusiveMinimum;
            }

            public int maxLength() {
                return Builder.this.maxLength;
            }

            public int minLength() {
                return Builder.this.minLength;
            }

            public String pattern() {
                return Builder.this.pattern;
            }

            public int maxProperties() {
                return Builder.this.maxProperties;
            }

            public int minProperties() {
                return Builder.this.minProperties;
            }

            public String[] requiredProperties() {
                return Builder.this.requiredProperties;
            }

            public boolean required() {
                return Builder.this.required;
            }

            public String description() {
                return Builder.this.description;
            }

            public String format() {
                return Builder.this.format;
            }

            public String ref() {
                return Builder.this.ref;
            }

            public boolean nullable() {
                return Builder.this.nullable;
            }

            public boolean readOnly() {
                return Schema.AccessMode.READ_ONLY.equals((Object)Builder.this.accessMode);
            }

            public boolean writeOnly() {
                return Schema.AccessMode.WRITE_ONLY.equals((Object)Builder.this.accessMode);
            }

            public Schema.AccessMode accessMode() {
                return Builder.this.accessMode;
            }

            public String example() {
                return Builder.this.example;
            }

            public ExternalDocumentation externalDocs() {
                return Builder.this.externalDocs;
            }

            public boolean deprecated() {
                return Builder.this.deprecated;
            }

            public String type() {
                return Builder.this.type;
            }

            public String[] allowableValues() {
                return Builder.this.allowableValues;
            }

            public String defaultValue() {
                return Builder.this.defaultValue;
            }

            public String discriminatorProperty() {
                return Builder.this.discriminatorProperty;
            }

            public DiscriminatorMapping[] discriminatorMapping() {
                return Builder.this.discriminatorMapping;
            }

            public boolean hidden() {
                return Builder.this.hidden;
            }

            public boolean enumAsRef() {
                return Builder.this.enumAsRef;
            }

            public Class<?>[] subTypes() {
                return Builder.this.subTypes;
            }

            public Extension[] extensions() {
                return Builder.this.extensions;
            }
        };
    }
}

