/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AnnotationsUtils
extends io.swagger.v3.core.util.AnnotationsUtils {
    static final String COMPONENTS_REF = "#/components/schemas/";

    private AnnotationsUtils() {
    }

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonViewAnnotation) {
        Schema schemaObject = null;
        PrimitiveType primitiveType = PrimitiveType.fromType(schemaImplementation);
        if (primitiveType != null) {
            schemaObject = primitiveType.createProperty();
        } else {
            schemaObject = new Schema();
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(schemaImplementation).jsonViewAnnotation(jsonViewAnnotation));
            if (resolvedSchema != null) {
                Map schemaMap = resolvedSchema.referencedSchemas;
                schemaMap.forEach((key, referencedSchema) -> {
                    if (components != null) {
                        components.addSchemas(key, referencedSchema);
                    }
                });
                if (StringUtils.isNotBlank((CharSequence)resolvedSchema.schema.getName())) {
                    schemaObject.set$ref(COMPONENTS_REF + resolvedSchema.schema.getName());
                } else {
                    schemaObject = resolvedSchema.schema;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType())) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation) {
        if (annotationContents == null || annotationContents.length == 0) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            Encoding[] encodings;
            Map extensions;
            ExampleObject[] examples;
            MediaType mediaType = new MediaType();
            if (!annotationContent.schema().hidden()) {
                if (components != null) {
                    AnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Content)annotationContent, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
                } else {
                    mediaType.setSchema(schema);
                }
            }
            if ((examples = annotationContent.examples()).length == 1 && StringUtils.isBlank((CharSequence)examples[0].name())) {
                AnnotationsUtils.getExample((ExampleObject)examples[0], (boolean)true).ifPresent(exampleObject -> mediaType.example(exampleObject.getValue()));
            } else {
                for (ExampleObject example : examples) {
                    AnnotationsUtils.getExample((ExampleObject)example).ifPresent(exampleObject -> mediaType.addExamples(example.name(), exampleObject));
                }
            }
            if (annotationContent.extensions() != null && annotationContent.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])annotationContent.extensions())) != null) {
                for (String ext : extensions.keySet()) {
                    mediaType.addExtension(ext, extensions.get(ext));
                }
            }
            for (Encoding encoding : encodings = annotationContent.encoding()) {
                AnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, (Encoding)encoding, (JsonView)jsonViewAnnotation);
            }
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            AnnotationsUtils.applyTypes((String[])classTypes, (String[])methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }
}

