/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RequestBodyBuilder {
    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, String[] classConsumes, String[] methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        } else {
            requestBodyObject.setDescription("default response");
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])requestBody.extensions());
            if (extensions != null) {
                for (Map.Entry entry : extensions.entrySet()) {
                    requestBodyObject.addExtension((String)entry.getKey(), entry.getValue());
                }
            }
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes), (String[])(methodConsumes == null ? new String[]{} : methodConsumes), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }
}

