/*
 * Decompiled with CFR 0.152.
 */
package com.baeldung.springdoc.controller;

import com.baeldung.springdoc.exception.BookNotFoundException;
import com.baeldung.springdoc.model.Book;
import com.baeldung.springdoc.repository.BookRepository;
import java.util.Collection;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/book"})
public class BookController {
    @Autowired
    private BookRepository repository;

    @GetMapping(value={"/{id}"})
    public Book findById(@PathVariable long id) {
        return this.repository.findById(id).orElseThrow(() -> new BookNotFoundException());
    }

    @GetMapping(value={"/"})
    public Collection<Book> findBooks() {
        return this.repository.getBooks();
    }

    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Book updateBook(@PathVariable(value="id") String id, @RequestBody Book book) {
        return book;
    }

    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Book patchBook(@PathVariable(value="id") String id, @RequestBody Book book) {
        return book;
    }

    @PostMapping(value={"/"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Book postBook(@NotNull @Valid @RequestBody Book book) {
        return book;
    }

    @RequestMapping(method={RequestMethod.HEAD}, value={"/"})
    @ResponseStatus(value=HttpStatus.OK)
    public Book headBook() {
        return new Book();
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public long deleteBook(@PathVariable long id) {
        return id;
    }
}

