/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.elicitation;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import org.springaicommunity.mcp.context.StructuredElicitResult;
import org.springaicommunity.mcp.method.elicitation.AbstractMcpElicitationMethodCallback;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;
import reactor.core.publisher.Mono;

public final class AsyncMcpElicitationMethodCallback
extends AbstractMcpElicitationMethodCallback
implements Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> {
    private AsyncMcpElicitationMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public Mono<McpSchema.ElicitResult> apply(McpSchema.ElicitRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        try {
            Object[] args = this.buildArgs(this.method, null, request);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            if (result instanceof Mono) {
                Mono monoResult = (Mono)result;
                return monoResult.flatMap(value -> {
                    if (value instanceof StructuredElicitResult) {
                        StructuredElicitResult structuredElicitResult = (StructuredElicitResult)value;
                        Map<String, Object> content = structuredElicitResult.structuredContent() != null ? JsonParser.convertObjectToMap(structuredElicitResult.structuredContent()) : null;
                        return Mono.just((Object)McpSchema.ElicitResult.builder().message(structuredElicitResult.action()).content(content).meta(structuredElicitResult.meta()).build());
                    }
                    if (value instanceof McpSchema.ElicitResult) {
                        return Mono.just((Object)((McpSchema.ElicitResult)value));
                    }
                    return Mono.error((Throwable)new AbstractMcpElicitationMethodCallback.McpElicitationMethodException("Method must return Mono<ElicitResult> or Mono<StructuredElicitResult>: " + this.method.getName()));
                });
            }
            return Mono.error((Throwable)new AbstractMcpElicitationMethodCallback.McpElicitationMethodException("Method must return Mono<ElicitResult> or Mono<StructuredElicitResult>: " + this.method.getName()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)new AbstractMcpElicitationMethodCallback.McpElicitationMethodException("Error invoking elicitation method: " + this.method.getName(), e));
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!Mono.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must return Mono<ElicitResult> or Mono<StructuredElicitResult>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeType(Class<?> paramType) {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpElicitationMethodCallback.AbstractBuilder<Builder, AsyncMcpElicitationMethodCallback> {
        @Override
        public AsyncMcpElicitationMethodCallback build() {
            this.validate();
            return new AsyncMcpElicitationMethodCallback(this);
        }
    }
}

