/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.complete;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.McpPredicates;
import org.springaicommunity.mcp.adapter.CompleteAdapter;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.method.complete.AsyncMcpCompleteMethodCallback;

public class AsyncMcpCompleteProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMcpCompleteProvider.class);
    private final List<Object> completeObjects;

    public AsyncMcpCompleteProvider(List<Object> completeObjects) {
        Assert.notNull(completeObjects, (String)"completeObjects cannot be null");
        this.completeObjects = completeObjects;
    }

    public List<McpServerFeatures.AsyncCompletionSpecification> getCompleteSpecifications() {
        List<McpServerFeatures.AsyncCompletionSpecification> asyncCompleteSpecification = this.completeObjects.stream().map(completeObject -> Stream.of(this.doGetClassMethods(completeObject)).filter(method -> method.isAnnotationPresent(McpComplete.class)).filter(McpPredicates.filterNonReactiveReturnTypeMethod()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpCompleteMethod -> {
            McpComplete completeAnnotation = mcpCompleteMethod.getAnnotation(McpComplete.class);
            McpSchema.CompleteReference completeRef = CompleteAdapter.asCompleteReference(completeAnnotation, mcpCompleteMethod);
            AsyncMcpCompleteMethodCallback methodCallback = ((AsyncMcpCompleteMethodCallback.Builder)((AsyncMcpCompleteMethodCallback.Builder)((AsyncMcpCompleteMethodCallback.Builder)((AsyncMcpCompleteMethodCallback.Builder)AsyncMcpCompleteMethodCallback.builder().method((Method)mcpCompleteMethod)).bean(completeObject)).prompt(completeAnnotation.prompt().isEmpty() ? null : completeAnnotation.prompt())).uri(completeAnnotation.uri().isEmpty() ? null : completeAnnotation.uri())).build();
            return new McpServerFeatures.AsyncCompletionSpecification(completeRef, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (asyncCompleteSpecification.isEmpty()) {
            logger.warn("No async complete methods found in the provided complete objects: {}", this.completeObjects);
        }
        return asyncCompleteSpecification;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

