/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.tool;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.method.tool.AsyncStatelessMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.ReactiveUtils;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.utils.ClassUtils;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;
import org.springaicommunity.mcp.provider.ProvidrerUtils;
import org.springaicommunity.mcp.provider.tool.AbstractMcpToolProvider;

public class AsyncStatelessMcpToolProvider
extends AbstractMcpToolProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStatelessMcpToolProvider.class);

    public AsyncStatelessMcpToolProvider(List<Object> toolObjects) {
        super(toolObjects);
    }

    public List<McpStatelessServerFeatures.AsyncToolSpecification> getToolSpecifications() {
        List<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecs = this.toolObjects.stream().map(toolObject -> Stream.of(this.doGetClassMethods(toolObject)).filter(method -> method.isAnnotationPresent(McpTool.class)).filter(ProvidrerUtils.isReactiveReturnType).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpToolMethod -> {
            McpSchema.Tool tool;
            McpTool toolJavaAnnotation = this.doGetMcpToolAnnotation((Method)mcpToolMethod);
            String toolName = Utils.hasText((String)toolJavaAnnotation.name()) ? toolJavaAnnotation.name() : mcpToolMethod.getName();
            String toolDescrption = toolJavaAnnotation.description();
            String inputSchema = JsonSchemaGenerator.generateForMethodInput(mcpToolMethod);
            McpSchema.Tool.Builder toolBuilder = McpSchema.Tool.builder().name(toolName).description(toolDescrption).inputSchema(this.getJsonMapper(), inputSchema);
            String title = toolJavaAnnotation.title();
            if (toolJavaAnnotation.annotations() != null) {
                McpTool.McpAnnotations toolAnnotations = toolJavaAnnotation.annotations();
                toolBuilder.annotations(new McpSchema.ToolAnnotations(toolAnnotations.title(), Boolean.valueOf(toolAnnotations.readOnlyHint()), Boolean.valueOf(toolAnnotations.destructiveHint()), Boolean.valueOf(toolAnnotations.idempotentHint()), Boolean.valueOf(toolAnnotations.openWorldHint()), null));
                if (!Utils.hasText((String)title)) {
                    title = toolAnnotations.title();
                }
            }
            if (!Utils.hasText((String)title)) {
                title = toolName;
            }
            toolBuilder.title(title);
            if (toolJavaAnnotation.generateOutputSchema() && !ReactiveUtils.isReactiveReturnTypeOfVoid(mcpToolMethod) && !ReactiveUtils.isReactiveReturnTypeOfCallToolResult(mcpToolMethod)) {
                ReactiveUtils.getReactiveReturnTypeArgument(mcpToolMethod).ifPresent(typeArgument -> {
                    Class methodReturnType;
                    Class clazz = methodReturnType = typeArgument instanceof Class ? (Class)typeArgument : null;
                    if (!ClassUtils.isPrimitiveOrWrapper(methodReturnType) && !ClassUtils.isSimpleValueType(methodReturnType)) {
                        toolBuilder.outputSchema(this.getJsonMapper(), JsonSchemaGenerator.generateFromType(typeArgument));
                    }
                });
            }
            ReturnMode returnMode = (tool = toolBuilder.build()).outputSchema() != null ? ReturnMode.STRUCTURED : (ReactiveUtils.isReactiveReturnTypeOfVoid(mcpToolMethod) ? ReturnMode.VOID : ReturnMode.TEXT);
            AsyncStatelessMcpToolMethodCallback methodCallback = new AsyncStatelessMcpToolMethodCallback(returnMode, (Method)mcpToolMethod, toolObject, this.doGetToolCallException());
            McpStatelessServerFeatures.AsyncToolSpecification toolSpec = McpStatelessServerFeatures.AsyncToolSpecification.builder().tool(tool).callHandler((BiFunction)methodCallback).build();
            return toolSpec;
        }).toList()).flatMap(Collection::stream).toList();
        if (toolSpecs.isEmpty()) {
            logger.warn("No tool methods found in the provided tool objects: {}", (Object)this.toolObjects);
        }
        return toolSpecs;
    }
}

