/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.tool;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.method.tool.AsyncStatelessMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.ReactiveUtils;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.utils.ClassUtils;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncStatelessMcpToolProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStatelessMcpToolProvider.class);
    private final List<Object> toolObjects;

    public AsyncStatelessMcpToolProvider(List<Object> toolObjects) {
        Assert.notNull(toolObjects, (String)"toolObjects cannot be null");
        this.toolObjects = toolObjects;
    }

    public List<McpStatelessServerFeatures.AsyncToolSpecification> getToolSpecifications() {
        List<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecs = this.toolObjects.stream().map(toolObject -> Stream.of(this.doGetClassMethods(toolObject)).filter(method -> method.isAnnotationPresent(McpTool.class)).filter(method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType())).map(mcpToolMethod -> {
            McpSchema.Tool tool;
            McpTool toolAnnotation = this.doGetMcpToolAnnotation((Method)mcpToolMethod);
            String toolName = Utils.hasText((String)toolAnnotation.name()) ? toolAnnotation.name() : mcpToolMethod.getName();
            String toolDescrption = toolAnnotation.description();
            String inputSchema = JsonSchemaGenerator.generateForMethodInput(mcpToolMethod);
            McpSchema.Tool.Builder toolBuilder = McpSchema.Tool.builder().name(toolName).description(toolDescrption).inputSchema(inputSchema);
            if (toolAnnotation.annotations() != null) {
                McpTool.McpAnnotations toolAnnotations = toolAnnotation.annotations();
                toolBuilder.annotations(new McpSchema.ToolAnnotations(toolAnnotations.title(), Boolean.valueOf(toolAnnotations.readOnlyHint()), Boolean.valueOf(toolAnnotations.destructiveHint()), Boolean.valueOf(toolAnnotations.idempotentHint()), Boolean.valueOf(toolAnnotations.openWorldHint()), null));
            }
            if (toolAnnotation.generateOutputSchema() && !ReactiveUtils.isReactiveReturnTypeOfVoid(mcpToolMethod) && !ReactiveUtils.isReactiveReturnTypeOfCallToolResult(mcpToolMethod)) {
                ReactiveUtils.getReactiveReturnTypeArgument(mcpToolMethod).ifPresent(typeArgument -> {
                    Class methodReturnType;
                    Class clazz = methodReturnType = typeArgument instanceof Class ? (Class)typeArgument : null;
                    if (!ClassUtils.isPrimitiveOrWrapper(methodReturnType) && !ClassUtils.isSimpleValueType(methodReturnType)) {
                        toolBuilder.outputSchema(JsonSchemaGenerator.generateFromClass((Class)typeArgument));
                    }
                });
            }
            ReturnMode returnMode = (tool = toolBuilder.build()).outputSchema() != null ? ReturnMode.STRUCTURED : (ReactiveUtils.isReactiveReturnTypeOfVoid(mcpToolMethod) ? ReturnMode.VOID : ReturnMode.TEXT);
            AsyncStatelessMcpToolMethodCallback methodCallback = new AsyncStatelessMcpToolMethodCallback(returnMode, (Method)mcpToolMethod, toolObject);
            McpStatelessServerFeatures.AsyncToolSpecification toolSpec = McpStatelessServerFeatures.AsyncToolSpecification.builder().tool(tool).callHandler((BiFunction)methodCallback).build();
            return toolSpec;
        }).toList()).flatMap(Collection::stream).toList();
        if (toolSpecs.isEmpty()) {
            logger.warn("No tool methods found in the provided tool objects: {}", this.toolObjects);
        }
        return toolSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }

    protected McpTool doGetMcpToolAnnotation(Method method) {
        return method.getAnnotation(McpTool.class);
    }
}

