/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.prompt;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.adapter.PromptAdapter;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.method.prompt.SyncStatelessMcpPromptMethodCallback;
import reactor.core.publisher.Mono;

public class SyncStatelessMcpPromptProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatelessMcpPromptProvider.class);
    private final List<Object> promptObjects;

    public SyncStatelessMcpPromptProvider(List<Object> promptObjects) {
        Assert.notNull(promptObjects, (String)"promptObjects cannot be null");
        this.promptObjects = promptObjects;
    }

    public List<McpStatelessServerFeatures.SyncPromptSpecification> getPromptSpecifications() {
        List<McpStatelessServerFeatures.SyncPromptSpecification> promptSpecs = this.promptObjects.stream().map(promptObject -> Stream.of(this.doGetClassMethods(promptObject)).filter(method -> method.isAnnotationPresent(McpPrompt.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).map(mcpPromptMethod -> {
            McpPrompt promptAnnotation = mcpPromptMethod.getAnnotation(McpPrompt.class);
            McpSchema.Prompt mcpPrompt = PromptAdapter.asPrompt(promptAnnotation, mcpPromptMethod);
            SyncStatelessMcpPromptMethodCallback methodCallback = ((SyncStatelessMcpPromptMethodCallback.Builder)((SyncStatelessMcpPromptMethodCallback.Builder)((SyncStatelessMcpPromptMethodCallback.Builder)SyncStatelessMcpPromptMethodCallback.builder().method((Method)mcpPromptMethod)).bean(promptObject)).prompt(mcpPrompt)).build();
            return new McpStatelessServerFeatures.SyncPromptSpecification(mcpPrompt, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (promptSpecs.isEmpty()) {
            logger.warn("No prompt methods found in the provided prompt objects: {}", this.promptObjects);
        }
        return promptSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

