/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.resource;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.method.resource.SyncMcpResourceMethodCallback;
import reactor.core.publisher.Mono;

public class SyncMcpResourceProvider {
    private final List<Object> resourceObjects;

    public SyncMcpResourceProvider(List<Object> resourceObjects) {
        Assert.notNull(resourceObjects, (String)"resourceObjects cannot be null");
        this.resourceObjects = resourceObjects;
    }

    public List<McpServerFeatures.SyncResourceSpecification> getResourceSpecifications() {
        List<McpServerFeatures.SyncResourceSpecification> methodCallbacks = this.resourceObjects.stream().map(resourceObject -> Stream.of(this.doGetClassMethods(resourceObject)).filter(resourceMethod -> resourceMethod.isAnnotationPresent(McpResource.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).map(mcpResourceMethod -> {
            McpResource resourceAnnotation = mcpResourceMethod.getAnnotation(McpResource.class);
            String uri = resourceAnnotation.uri();
            String name = SyncMcpResourceProvider.getName(mcpResourceMethod, resourceAnnotation);
            String description = resourceAnnotation.description();
            String mimeType = resourceAnnotation.mimeType();
            McpSchema.Resource mcpResource = McpSchema.Resource.builder().uri(uri).name(name).description(description).mimeType(mimeType).build();
            SyncMcpResourceMethodCallback methodCallback = ((SyncMcpResourceMethodCallback.Builder)((SyncMcpResourceMethodCallback.Builder)((SyncMcpResourceMethodCallback.Builder)SyncMcpResourceMethodCallback.builder().method((Method)mcpResourceMethod)).bean(resourceObject)).resource(mcpResource)).build();
            return new McpServerFeatures.SyncResourceSpecification(mcpResource, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        return methodCallbacks;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }

    private static String getName(Method method, McpResource resource) {
        Assert.notNull((Object)method, (String)"method cannot be null");
        if (resource == null || resource.name() == null || resource.name().isEmpty()) {
            return method.getName();
        }
        return resource.name();
    }
}

