/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.complete;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.CompleteAdapter;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.method.complete.SyncStatelessMcpCompleteMethodCallback;
import reactor.core.publisher.Mono;

public class SyncStatelessMcpCompleteProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatelessMcpCompleteProvider.class);
    private final List<Object> completeObjects;

    public SyncStatelessMcpCompleteProvider(List<Object> completeObjects) {
        Assert.notNull(completeObjects, (String)"completeObjects cannot be null");
        this.completeObjects = completeObjects;
    }

    public List<McpStatelessServerFeatures.SyncCompletionSpecification> getCompleteSpecifications() {
        List<McpStatelessServerFeatures.SyncCompletionSpecification> completeSpecs = this.completeObjects.stream().map(completeObject -> Stream.of(this.doGetClassMethods(completeObject)).filter(method -> method.isAnnotationPresent(McpComplete.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).map(mcpCompleteMethod -> {
            McpComplete completeAnnotation = mcpCompleteMethod.getAnnotation(McpComplete.class);
            McpSchema.CompleteReference completeRef = CompleteAdapter.asCompleteReference(completeAnnotation, mcpCompleteMethod);
            SyncStatelessMcpCompleteMethodCallback methodCallback = ((SyncStatelessMcpCompleteMethodCallback.Builder)((SyncStatelessMcpCompleteMethodCallback.Builder)((SyncStatelessMcpCompleteMethodCallback.Builder)SyncStatelessMcpCompleteMethodCallback.builder().method((Method)mcpCompleteMethod)).bean(completeObject)).complete(completeAnnotation)).build();
            return new McpStatelessServerFeatures.SyncCompletionSpecification(completeRef, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (completeSpecs.isEmpty()) {
            logger.warn("No complete methods found in the provided complete objects: {}", this.completeObjects);
        }
        return completeSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

