/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.economy.account;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransferResult;

public interface Account
extends Contextual {
    public Component displayName();

    public BigDecimal defaultBalance(Currency var1);

    public boolean hasBalance(Currency var1, Set<Context> var2);

    public boolean hasBalance(Currency var1, Cause var2);

    default public boolean hasBalance(Currency currency) {
        return this.hasBalance(currency, this.contextCause());
    }

    public BigDecimal balance(Currency var1, Set<Context> var2);

    public BigDecimal balance(Currency var1, Cause var2);

    default public BigDecimal balance(Currency currency) {
        return this.balance(currency, this.contextCause());
    }

    public Map<Currency, BigDecimal> balances(Set<Context> var1);

    public Map<Currency, BigDecimal> balances(Cause var1);

    default public Map<Currency, BigDecimal> balances() {
        return this.balances(this.contextCause());
    }

    public TransactionResult setBalance(Currency var1, BigDecimal var2, Set<Context> var3);

    public TransactionResult setBalance(Currency var1, BigDecimal var2, Cause var3);

    default public TransactionResult setBalance(Currency currency, BigDecimal amount) {
        return this.setBalance(currency, amount, this.contextCause());
    }

    public Map<Currency, TransactionResult> resetBalances(Set<Context> var1);

    public Map<Currency, TransactionResult> resetBalances(Cause var1);

    default public Map<Currency, TransactionResult> resetBalances() {
        return this.resetBalances(this.contextCause());
    }

    public TransactionResult resetBalance(Currency var1, Set<Context> var2);

    public TransactionResult resetBalance(Currency var1, Cause var2);

    default public TransactionResult resetBalance(Currency currency) {
        return this.resetBalance(currency, this.contextCause());
    }

    public TransactionResult deposit(Currency var1, BigDecimal var2, Set<Context> var3);

    public TransactionResult deposit(Currency var1, BigDecimal var2, Cause var3);

    default public TransactionResult deposit(Currency currency, BigDecimal amount) {
        return this.deposit(currency, amount, this.contextCause());
    }

    public TransactionResult withdraw(Currency var1, BigDecimal var2, Set<Context> var3);

    public TransactionResult withdraw(Currency var1, BigDecimal var2, Cause var3);

    default public TransactionResult withdraw(Currency currency, BigDecimal amount) {
        return this.withdraw(currency, amount, this.contextCause());
    }

    public TransferResult transfer(Account var1, Currency var2, BigDecimal var3, Set<Context> var4);

    public TransferResult transfer(Account var1, Currency var2, BigDecimal var3, Cause var4);

    default public TransferResult transfer(Account to, Currency currency, BigDecimal amount) {
        return this.transfer(to, currency, amount, this.contextCause());
    }
}

